Print ''                
Print '-------------------------------------------------------------------------'
Print ' using Database: #DB_N#'
Print ' Table         : [tblMesslinien]'
Print ' Creation Date : 13.11.2012'
Print ' Autor         : S.Gueth'
Print '-------------------------------------------------------------------------'

use [#DB_N#]

Declare @MyActionMsg1 nvarchar (max)
Declare @MyTableName nvarchar (max)
set @MyTableName='tblMesslinien'
DECLARE @ExecuteSQLstr nvarchar(max)

declare @indexNrCur  int
declare @indexNrEnd  int
declare @indexNrStr       varchar(32)
declare @IndexName        varchar(max)
declare @ProcStateColName varchar(max)
set @indexNrEnd = 10


--------------------------------------------------------------------------------
-- verzweigen auf TableCreate: oder TableUpdate:
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[tblMesslinien]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
  BEGIN
   goto TableUpdate
  END
ELSE
  BEGIN
   goto TableCreate
  END

--------------------------------------------------------------------------------
TableCreate:
  set @MyActionMsg1=
      '-- Table: [tblMesslinien] dose not exist and will be created new'

  Print (@MyActionMsg1)


  CREATE TABLE tblMesslinien
  (
          [MesslinieID]         int NOT NULL,
          [MesslinieName]       nvarchar( 50) NOT NULL,
          [Reihenfolge]         int,
          [PerfMessColor]       nvarchar( 20),
          [PingMessColor]       nvarchar( 20),
          [Visible]             int,
          [IncludePingMess]     int,
          [RelatedMesslinieId]  int,
          [UserCountColor]      nvarchar( 20),  -- fuer farbsteuerung der UserCount.Messlinie (#New: 11.01.2013 S.Gueth)
          [UserCountLabel]      nvarchar( 20),  -- fuer Label Text UserCount.Messlinie (#New: 11.01.2013 S.Gueth)
          [IncludeStartzeiten]  int,            -- fuer Startzeienmessung von Teamcenter und NX (#New: 20.03.2013)
		  [IsWorkflow]          int,            -- for workflow error messaruement from TC (#New: 3.1447;19.01.2018;S.Gueth)
		  [WorklflowColor]      nvarchar( 20),  -- color for total workflow measure bar (#New: 3.1447;19.01.2018;S.Gueth)
		  [WorklflowErrorColor] nvarchar( 20),  -- color for error workflow measure bar (#New: 3.1490;25.10.2019;S.Gueth)
		  [KPI_OK]              float,          -- KPI value that devines the boarder between ok and warning (#New: 3.1442;04.12.2017;S.Gueth)
		  [KPI_ERR]             float,          -- KPI value that devines the boarder between warning and error (#New: 3.1442;04.12.2017;S.Gueth)
		  [KPIUser_OK]          float,          -- KPI value that devines the boarder between ok and warning (#New: 3.1442;04.12.2017;S.Gueth)
		  [KPIUser_ERR]         float,          -- KPI value that devines the boarder between warning and error (#New: 3.1442;04.12.2017;S.Gueth)
		  [GroupAction]       nvarchar( 50),  -- Field to group measurement lines by location (#New: 3.1445;22.12.2017;S.Gueth)
          [GroupWorldregion]         nvarchar( 50),  -- Field to group measurement lines by method (#New: 3.1445;22.12.2017;S.Gueth)
		  [GroupCountry]         nvarchar( 50),
		  [GroupSite]         nvarchar( 50),
		  [GroupDepartement]         nvarchar( 50),
		  [GroupCustom]         nvarchar( 50),  -- Field to group measurement lines by costom value (#New: 3.1445;22.12.2017;S.Gueth)
          CONSTRAINT tblMesslinien_PK PRIMARY KEY ([MesslinieID])
  )
  ON [PRIMARY]
  
  INSERT INTO tblMesslinien (MesslinieID, MesslinieName, Reihenfolge, PerfMessColor, PingMessColor) VALUES (1, 'Test Messlinie', 0, 'Blue', 'Yellow')



  goto CheckCreateIndex

--------------------------------------------------------------------------------
TableUpdate:

  set @MyActionMsg1=
       '-- Table: [' + @MyTableName + '] exist and will be updated'
  Print (@MyActionMsg1)

  Declare @ColumeName nvarchar (256)
  Declare @ColumeNameOld nvarchar (256)
  Declare @ColumeNameNew nvarchar (256)
  Declare @ExecuteStr nvarchar (max)


  set @ColumeName='UserCountColor'
  if (Select Coalesce(Col_length(@MyTableName,@ColumeName),0)) = 0
  begin
      print ('Create Column:[' + @ColumeName + '] fuer farbsteuerung der UserCount.Messlinie (#New: 11.01.2013 S.Gueth)'  )
      set @ExecuteStr='ALTER TABLE [dbo].[' + @MyTableName + '] ADD [' + @ColumeName +'] nvarchar(20)'
      execute (@ExecuteStr)
  end

  set @ColumeName='UserCountLabel'
  if (Select Coalesce(Col_length(@MyTableName,@ColumeName),0)) = 0
  begin
      print ('Create Column:[' + @ColumeName + '] fuer Label Text UserCount.Messlinie (#New: 11.01.2013 S.Gueth)')
      set @ExecuteStr='ALTER TABLE [dbo].[' + @MyTableName + '] ADD [' + @ColumeName +'] nvarchar(20)'
      execute (@ExecuteStr)
  end

  set @ColumeName='IncludeStartzeiten'
  if (Select Coalesce(Col_length(@MyTableName,@ColumeName),0)) = 0
  begin
      print ('Create Column:[' + @ColumeName + '] fuer Startzeienmessung von Teamcenter und NX (#New: 20.03.2013)')
      set @ExecuteStr='ALTER TABLE [dbo].[' + @MyTableName + '] ADD [' + @ColumeName +'] int'
      execute (@ExecuteStr)
  end

  set @ColumeName='IsWorkflow'
  if (Select Coalesce(Col_length(@MyTableName,@ColumeName),0)) = 0
  begin
      print ('Create Column:[' + @ColumeName + '] for workflow error messaruement from TC (#New: 3.1447;19.01.2018;S.Gueth)')
      set @ExecuteStr='ALTER TABLE [dbo].[' + @MyTableName + '] ADD [' + @ColumeName +'] int'
      execute (@ExecuteStr)
  end

  set @ColumeName='WorklflowColor'
  if (Select Coalesce(Col_length(@MyTableName,@ColumeName),0)) = 0
  begin
      print ('Create Column:[' + @ColumeName + '] color for total workflow measure bar (#New: 3.1447;19.01.2018;S.Gueth)')
      set @ExecuteStr='ALTER TABLE [dbo].[' + @MyTableName + '] ADD [' + @ColumeName +'] nvarchar(20)'
      execute (@ExecuteStr)
  end

  set @ColumeName='WorklflowErrorColor'
  if (Select Coalesce(Col_length(@MyTableName,@ColumeName),0)) = 0
  begin
      print ('Create Column:[' + @ColumeName + '] color for error workflow measure bar (#New: 3.1490;25.10.2019;S.Gueth)')
      set @ExecuteStr='ALTER TABLE [dbo].[' + @MyTableName + '] ADD [' + @ColumeName +'] nvarchar(20)'
      execute (@ExecuteStr)
  end

  set @ColumeName='KPI_OK'
  if (Select Coalesce(Col_length(@MyTableName,@ColumeName),0)) = 0
  begin
      print ('Create Column:[' + @ColumeName + '] fuer kpi value ok (#New: 3.1442;04.12.2017;S.Gueth)')
      set @ExecuteStr='ALTER TABLE [dbo].[' + @MyTableName + '] ADD [' + @ColumeName +'] float'
      execute (@ExecuteStr)
  end

   set @ColumeName='KPI_ERR'
  if (Select Coalesce(Col_length(@MyTableName,@ColumeName),0)) = 0
  begin
      print ('Create Column:[' + @ColumeName + '] fuer kpi value err (#New: 3.1442;04.12.2017;S.Gueth)')
      set @ExecuteStr='ALTER TABLE [dbo].[' + @MyTableName + '] ADD [' + @ColumeName +'] float'
      execute (@ExecuteStr)
  end

  set @ColumeName='KPIUser_OK'
  if (Select Coalesce(Col_length(@MyTableName,@ColumeName),0)) = 0
  begin
      print ('Create Column:[' + @ColumeName + '] fuer kpi user value ok (#New: 3.1445;22.12.2017;S.Gueth)')
      set @ExecuteStr='ALTER TABLE [dbo].[' + @MyTableName + '] ADD [' + @ColumeName +'] float'
      execute (@ExecuteStr)
  end

   set @ColumeName='KPIUser_ERR'
  if (Select Coalesce(Col_length(@MyTableName,@ColumeName),0)) = 0
  begin
      print ('Create Column:[' + @ColumeName + '] fuer kpi user value err (#New: 3.1445;22.12.2017;S.Gueth)')
      set @ExecuteStr='ALTER TABLE [dbo].[' + @MyTableName + '] ADD [' + @ColumeName +'] float'
      execute (@ExecuteStr)
  end

  set @ColumeName='GroupAction'
  if (Select Coalesce(Col_length(@MyTableName,@ColumeName),0)) = 0
  begin
      print ('Create Column:[' + @ColumeName + '] for grouping measurement line by location (#New: 3.1445;22.12.2017;S.Gueth)')
      set @ExecuteStr='ALTER TABLE [dbo].[' + @MyTableName + '] ADD [' + @ColumeName +'] nvarchar(50)'
      execute (@ExecuteStr)
  end

   set @ColumeName='GroupWorldregion'
  if (Select Coalesce(Col_length(@MyTableName,@ColumeName),0)) = 0
  begin
      print ('Create Column:[' + @ColumeName + '] for grouping measurement line by worldregion (#New: 3.1445;22.12.2017;S.Gueth)')
      set @ExecuteStr='ALTER TABLE [dbo].[' + @MyTableName + '] ADD [' + @ColumeName +'] nvarchar(50)'
      execute (@ExecuteStr)
  end

    set @ColumeName='GroupCountry'
  if (Select Coalesce(Col_length(@MyTableName,@ColumeName),0)) = 0
  begin
      print ('Create Column:[' + @ColumeName + '] for grouping measurement line by country (#New: 3.1445;22.12.2017;S.Gueth)')
      set @ExecuteStr='ALTER TABLE [dbo].[' + @MyTableName + '] ADD [' + @ColumeName +'] nvarchar(50)'
      execute (@ExecuteStr)
  end

    set @ColumeName='GroupSite'
  if (Select Coalesce(Col_length(@MyTableName,@ColumeName),0)) = 0
  begin
      print ('Create Column:[' + @ColumeName + '] for grouping measurement line by site (#New: 3.1445;22.12.2017;S.Gueth)')
      set @ExecuteStr='ALTER TABLE [dbo].[' + @MyTableName + '] ADD [' + @ColumeName +'] nvarchar(50)'
      execute (@ExecuteStr)
  end

    set @ColumeName='GroupDepartement'
  if (Select Coalesce(Col_length(@MyTableName,@ColumeName),0)) = 0
  begin
      print ('Create Column:[' + @ColumeName + '] for grouping measurement line by departement (#New: 3.1445;22.12.2017;S.Gueth)')
      set @ExecuteStr='ALTER TABLE [dbo].[' + @MyTableName + '] ADD [' + @ColumeName +'] nvarchar(50)'
      execute (@ExecuteStr)
  end

   set @ColumeName='GroupCustom'
  if (Select Coalesce(Col_length(@MyTableName,@ColumeName),0)) = 0
  begin
      print ('Create Column:[' + @ColumeName + '] for grouping measurement line by location (#New: 3.1445;22.12.2017;S.Gueth)')
      set @ExecuteStr='ALTER TABLE [dbo].[' + @MyTableName + '] ADD [' + @ColumeName +'] nvarchar(20)'
      execute (@ExecuteStr)
  end

goto CheckCreateIndex

--------------------------------------------------------------------------------
CheckCreateIndex:

  EXECUTE JF_PrimKeyCheckCreateDef 'tblMesslinien_pk',           @MyTableName, 'MesslinieID'
  EXECUTE JF_IndexCheckCreateDef   'tblMesslinien_ID',			 @MyTableName, 'MesslinieID' 

--------------------------------------------------------------------------------
EndeExit:
 Print ('   |-> Done on Database: #DB_N#')
 Print '------------------------------------------------------------------------'

GO
