

----- Table Start: tblMesslinien -------------------------------------------------------------------------------

-- #New: 3.1445;22.12.2017;S.Gueth

DECLARE
  TableNameVar VARCHAR2( 256) := 'tblMesslinien' ;
  ColumnNameVar VARCHAR2( 256) := 'KPIUser_OK' ;
  ColumnTypeVar VARCHAR2( 256) := 'FLOAT(7)' ;
  counterVar NUMBER(6, 0);
BEGIN
  SELECT COUNT(*) INTO counterVar
    from 
	  all_tab_cols
    where 
	  upper(table_name) = upper(TableNameVar) and 
	  upper(column_name) = upper(ColumnNameVar);
  IF( counterVar = 0 )  THEN
    EXECUTE IMMEDIATE 'Alter Table ' || TableNameVar || ' ADD ' || ColumnNameVar || ' ' || ColumnTypeVar || '';
  END IF;
END;
/

DECLARE
  TableNameVar VARCHAR2( 256) := 'tblMesslinien' ;
  ColumnNameVar VARCHAR2( 256) := 'KPIUser_ERR' ;
  ColumnTypeVar VARCHAR2( 256) := 'FLOAT(7)' ;
  counterVar NUMBER(6, 0);
BEGIN
  SELECT COUNT(*) INTO counterVar
    from 
	  all_tab_cols
    where 
	  upper(table_name) = upper(TableNameVar) and 
	  upper(column_name) = upper(ColumnNameVar);
  IF( counterVar = 0 )  THEN
    EXECUTE IMMEDIATE 'Alter Table ' || TableNameVar || ' ADD ' || ColumnNameVar || ' ' || ColumnTypeVar || '';
  END IF;
END;
/

DECLARE
  TableNameVar VARCHAR2( 256) := 'tblMesslinien' ;
  ColumnNameVar VARCHAR2( 256) := 'GroupAction' ;
  ColumnTypeVar VARCHAR2( 256) := 'VARCHAR2( 50)' ;
  counterVar NUMBER(6, 0);
BEGIN
  SELECT COUNT(*) INTO counterVar
    from 
	  all_tab_cols
    where 
	  upper(table_name) = upper(TableNameVar) and 
	  upper(column_name) = upper(ColumnNameVar);
  IF( counterVar = 0 )  THEN
    EXECUTE IMMEDIATE 'Alter Table ' || TableNameVar || ' ADD ' || ColumnNameVar || ' ' || ColumnTypeVar || '';
  END IF;
END;
/

DECLARE
  TableNameVar VARCHAR2( 256) := 'tblMesslinien' ;
  ColumnNameVar VARCHAR2( 256) := 'GroupWorldregion' ;
  ColumnTypeVar VARCHAR2( 256) := 'VARCHAR2( 50)' ;
  counterVar NUMBER(6, 0);
BEGIN
  SELECT COUNT(*) INTO counterVar
    from 
	  all_tab_cols
    where 
	  upper(table_name) = upper(TableNameVar) and 
	  upper(column_name) = upper(ColumnNameVar);
  IF( counterVar = 0 )  THEN
    EXECUTE IMMEDIATE 'Alter Table ' || TableNameVar || ' ADD ' || ColumnNameVar || ' ' || ColumnTypeVar || '';
  END IF;
END;
/

DECLARE
  TableNameVar VARCHAR2( 256) := 'tblMesslinien' ;
  ColumnNameVar VARCHAR2( 256) := 'GroupCountry' ;
  ColumnTypeVar VARCHAR2( 256) := 'VARCHAR2( 50)' ;
  counterVar NUMBER(6, 0);
BEGIN
  SELECT COUNT(*) INTO counterVar
    from 
	  all_tab_cols
    where 
	  upper(table_name) = upper(TableNameVar) and 
	  upper(column_name) = upper(ColumnNameVar);
  IF( counterVar = 0 )  THEN
    EXECUTE IMMEDIATE 'Alter Table ' || TableNameVar || ' ADD ' || ColumnNameVar || ' ' || ColumnTypeVar || '';
  END IF;
END;
/

DECLARE
  TableNameVar VARCHAR2( 256) := 'tblMesslinien' ;
  ColumnNameVar VARCHAR2( 256) := 'GroupSite' ;
  ColumnTypeVar VARCHAR2( 256) := 'VARCHAR2( 50)' ;
  counterVar NUMBER(6, 0);
BEGIN
  SELECT COUNT(*) INTO counterVar
    from 
	  all_tab_cols
    where 
	  upper(table_name) = upper(TableNameVar) and 
	  upper(column_name) = upper(ColumnNameVar);
  IF( counterVar = 0 )  THEN
    EXECUTE IMMEDIATE 'Alter Table ' || TableNameVar || ' ADD ' || ColumnNameVar || ' ' || ColumnTypeVar || '';
  END IF;
END;
/

DECLARE
  TableNameVar VARCHAR2( 256) := 'tblMesslinien' ;
  ColumnNameVar VARCHAR2( 256) := 'GroupDepartement' ;
  ColumnTypeVar VARCHAR2( 256) := 'VARCHAR2( 50)' ;
  counterVar NUMBER(6, 0);
BEGIN
  SELECT COUNT(*) INTO counterVar
    from 
	  all_tab_cols
    where 
	  upper(table_name) = upper(TableNameVar) and 
	  upper(column_name) = upper(ColumnNameVar);
  IF( counterVar = 0 )  THEN
    EXECUTE IMMEDIATE 'Alter Table ' || TableNameVar || ' ADD ' || ColumnNameVar || ' ' || ColumnTypeVar || '';
  END IF;
END;
/

DECLARE
  TableNameVar VARCHAR2( 256) := 'tblMesslinien' ;
  ColumnNameVar VARCHAR2( 256) := 'GroupCustom' ;
  ColumnTypeVar VARCHAR2( 256) := 'VARCHAR2( 50)' ;
  counterVar NUMBER(6, 0);
BEGIN
  SELECT COUNT(*) INTO counterVar
    from 
	  all_tab_cols
    where 
	  upper(table_name) = upper(TableNameVar) and 
	  upper(column_name) = upper(ColumnNameVar);
  IF( counterVar = 0 )  THEN
    EXECUTE IMMEDIATE 'Alter Table ' || TableNameVar || ' ADD ' || ColumnNameVar || ' ' || ColumnTypeVar || '';
  END IF;
END;
/

-- #New: 3.1447;19.01.2018;S.Gueth

DECLARE
  TableNameVar VARCHAR2( 256) := 'tblMesslinien' ;
  ColumnNameVar VARCHAR2( 256) := 'IsWorkflow' ;
  ColumnTypeVar VARCHAR2( 256) := 'NUMBER(6, 0)' ;
  counterVar NUMBER(6, 0);
BEGIN
  SELECT COUNT(*) INTO counterVar
    from 
	  all_tab_cols
    where 
	  upper(table_name) = upper(TableNameVar) and 
	  upper(column_name) = upper(ColumnNameVar);
  IF( counterVar = 0 )  THEN
    EXECUTE IMMEDIATE 'Alter Table ' || TableNameVar || ' ADD ' || ColumnNameVar || ' ' || ColumnTypeVar || '';
  END IF;
END;
/

DECLARE
  TableNameVar VARCHAR2( 256) := 'tblMesslinien' ;
  ColumnNameVar VARCHAR2( 256) := 'WorklflowColor' ;
  ColumnTypeVar VARCHAR2( 256) := 'VARCHAR2( 20)' ;
  counterVar NUMBER(6, 0);
BEGIN
  SELECT COUNT(*) INTO counterVar
    from 
	  all_tab_cols
    where 
	  upper(table_name) = upper(TableNameVar) and 
	  upper(column_name) = upper(ColumnNameVar);
  IF( counterVar = 0 )  THEN
    EXECUTE IMMEDIATE 'Alter Table ' || TableNameVar || ' ADD ' || ColumnNameVar || ' ' || ColumnTypeVar || '';
  END IF;
END;
/

DECLARE
  TableNameVar VARCHAR2( 256) := 'tblMesslinien' ;
  ColumnNameVar VARCHAR2( 256) := 'WorklflowErrorColor' ;
  ColumnTypeVar VARCHAR2( 256) := 'VARCHAR2( 20)' ;
  counterVar NUMBER(6, 0);
BEGIN
  SELECT COUNT(*) INTO counterVar
    from 
	  all_tab_cols
    where 
	  upper(table_name) = upper(TableNameVar) and 
	  upper(column_name) = upper(ColumnNameVar);
  IF( counterVar = 0 )  THEN
    EXECUTE IMMEDIATE 'Alter Table ' || TableNameVar || ' ADD ' || ColumnNameVar || ' ' || ColumnTypeVar || '';
	EXECUTE IMMEDIATE 'CREATE INDEX tblMess_ID ON tblMesslinien (MesslinieID)';
  END IF;
END;
/

----- Table End: tblMesslinien --------------------------------------------------------------------------------



----- Table Start: tblImportTypes ------------------------------------------------------------------------------

DECLARE
  TableNameVar VARCHAR2( 256) := 'TBLIMPORTTYPES' ;
  counterVar NUMBER(6, 0);
BEGIN
  SELECT COUNT(*) INTO counterVar
    from 
	  TBLIMPORTTYPES 
    where 
	  IMPORTTYPEID = 7;
  IF( counterVar = 0 )  THEN
    EXECUTE IMMEDIATE 'INSERT INTO ' || TableNameVar || ' (ImportTypeID, ImportType) VALUES (7, "Workflow")';
  END IF;
END;
/
----- Table End: tblImportTypes --------------------------------------------------------------------------------




----- Table Start: tblPerfMess ---------------------------------------------------------------------------------

DECLARE
  TableNameVar VARCHAR2( 256) := 'tblPerfMess' ;
  ColumnNameVar VARCHAR2( 256) := 'DateStamp' ;
  ColumnTypeVar VARCHAR2( 256) := 'VARCHAR2(10)' ;
  counterVar NUMBER(6, 0);
BEGIN
  SELECT COUNT(*) INTO counterVar
    from 
	  all_tab_cols
    where 
	  upper(table_name) = upper(TableNameVar) and 
	  upper(column_name) = upper(ColumnNameVar);
  IF( counterVar = 0 )  THEN
    EXECUTE IMMEDIATE 'Alter Table ' || TableNameVar || ' ADD ' || ColumnNameVar || ' ' || ColumnTypeVar || '';
	EXECUTE IMMEDIATE 'Update ' || TableNameVar || ' set ' || ColumnNameVar || ' = TO_CHAR(DateTimeStamp,''YYYY-MM-DD'')';
	EXECUTE IMMEDIATE 'CREATE INDEX tblPerf_DateStamp ON tblPerfMess (DateStamp)';
    EXECUTE IMMEDIATE 'CREATE INDEX tblPerf_DateStamp_MessungID ON tblPerfMess (DateStamp, MesslinieID)';
  END IF;
END;
/
----- Table End: tblPerfMess -----------------------------------------------------------------------------------





----- Table Start: tblPingMess ---------------------------------------------------------------------------------

DECLARE
  TableNameVar VARCHAR2( 256) := 'tblPingMess' ;
  ColumnNameVar VARCHAR2( 256) := 'DateStamp' ;
  ColumnTypeVar VARCHAR2( 256) := 'VARCHAR2(10)' ;
  counterVar NUMBER(6, 0);
BEGIN
  SELECT COUNT(*) INTO counterVar
    from 
	  all_tab_cols
    where 
	  upper(table_name) = upper(TableNameVar) and 
	  upper(column_name) = upper(ColumnNameVar);
  IF( counterVar = 0 )  THEN
    EXECUTE IMMEDIATE 'Alter Table ' || TableNameVar || ' ADD ' || ColumnNameVar || ' ' || ColumnTypeVar || '';	  
    EXECUTE IMMEDIATE 'Update ' || TableNameVar || ' set ' || ColumnNameVar || ' = TO_CHAR(DateTimeStamp,''YYYY-MM-DD'')';
	EXECUTE IMMEDIATE 'CREATE INDEX tblPing_DateStamp ON tblPingMess (DateStamp)';
    EXECUTE IMMEDIATE 'CREATE INDEX tblPing_DateStamp_PingAvg ON tblPingMess (DateStamp, PingAvg)';
  END IF;
END;
/


----- Table End: tblPingMess -----------------------------------------------------------------------------------





----- Table Start: tblUserCount --------------------------------------------------------------------------------

DECLARE
  TableNameVar VARCHAR2( 256) := 'tblUserCount' ;
  ColumnNameVar VARCHAR2( 256) := 'DateStamp' ;
  ColumnTypeVar VARCHAR2( 256) := 'VARCHAR2(10)' ;
  counterVar NUMBER(6, 0);
BEGIN
  SELECT COUNT(*) INTO counterVar
    from 
	  all_tab_cols
    where 
	  upper(table_name) = upper(TableNameVar) and 
	  upper(column_name) = upper(ColumnNameVar);
  IF( counterVar = 0 )  THEN
    EXECUTE IMMEDIATE 'Alter Table ' || TableNameVar || ' ADD ' || ColumnNameVar || ' ' || ColumnTypeVar || '';
	EXECUTE IMMEDIATE 'Update ' || TableNameVar || ' set ' || ColumnNameVar || ' = TO_CHAR(DateTimeStamp,''YYYY-MM-DD'')';
	EXECUTE IMMEDIATE 'CREATE INDEX User_DateStamp ON tblUserCount (DateStamp)';
    EXECUTE IMMEDIATE 'CREATE INDEX User_DateStamp_DATETIMESTAMP ON tblUserCount (DateStamp, DATETIMESTAMP)';
  END IF;
END;
/
----- Table End: tblUserCount ----------------------------------------------------------------------------------


DECLARE
  TableNameVar VARCHAR2( 256) := 'tblPingMessGroupedByDay' ;
  ColumnTypeVar VARCHAR2( 256) := 'VARCHAR2(10)' ;
  counterVar NUMBER(6, 0);
BEGIN
  select count(*) into counterVar 
  from tab 
  where 
  tname = upper('tblPingMessGroupedByDay');
  IF( counterVar = 0 )  THEN
    
	EXECUTE IMMEDIATE 'CREATE TABLE tblPingMessGroupedByDay ( MessAnzahl NUMBER(6, 0) , TimeStampGroup VARCHAR2(10), DateTimeStamp DATE NOT NULL, MesslinieID NUMBER(6, 0), PingAvg_Min NUMBER(6, 0) NOT NULL, PingAvg_Max NUMBER(6, 0) NOT NULL, PingAvg_Avg FLOAT(7) NOT NULL )';
    
	EXECUTE IMMEDIATE 'CREATE INDEX PingGrByDay_TST ON tblPingMessGroupedByDay (TimeStampGroup)';
	EXECUTE IMMEDIATE 'CREATE INDEX PingGrByDay_MesslinieID ON tblPingMessGroupedByDay (MesslinieID)';
	EXECUTE IMMEDIATE 'CREATE INDEX PingGrByDay_DTS ON tblPingMessGroupedByDay (DateTimeStamp)';
	EXECUTE IMMEDIATE 'CREATE INDEX PingGrByDay_TST_MessID ON tblPingMessGroupedByDay (TimeStampGroup,MesslinieID)';

	EXECUTE IMMEDIATE 'INSERT INTO tblPingMessGroupedByDay (MessAnzahl, TimeStampGroup, DateTimeStamp, MesslinieID,PingAvg_Min,PingAvg_Max,PingAvg_Avg) SELECT Count(PingMessID) AS MessAnzahl, DateStamp AS TimeStampGroup, Min(DateTimeStamp) AS DateTimeStamp, MesslinieID, ROUND(MIN(PingAvg),3) AS PingAvg_Min, ROUND(MAX(PingAvg),3) AS PingAvg_Max, AVG(PingAvg) AS PingAvg_Avg  FROM tblPingMess GROUP BY DateStamp, MesslinieID ORDER BY DateTimeStamp';

  END IF;
END;
/

-- #New: 3.1490;22.10.2019;S.Gueth
CREATE OR REPLACE TRIGGER PingMessDaily_Delete
AFTER DELETE
ON tblPingMess
FOR EACH ROW
DECLARE
 l_exst number(1);
BEGIN
select case
       when exists(SELECT 1 FROM tblPingMessGroupedByDay Where tblPingMessGroupedByDay.TimeStampGroup = :old.DateStamp and tblPingMessGroupedByDay.MesslinieID = :old.MesslinieID and tblPingMessGroupedByDay.MessAnzahl > 1)
       then 1          
       else 0           
      END into l_exst
from dual;
      
  if l_exst = 1 
  then
    	UPDATE tblPingMessGroupedByDay
              SET PingAvg_Avg = (PingAvg_Avg * MessAnzahl - :old.PingAvg) / (MessAnzahl - 1)
                 ,MessAnzahl = MessAnzahl - 1
              WHERE 
                tblPingMessGroupedByDay.TimeStampGroup = :old.DateStamp AND 
                tblPingMessGroupedByDay.MesslinieID = :old.MesslinieID;
  else
     DELETE FROM 
            tblPingMessGroupedByDay
            WHERE  
            tblPingMessGroupedByDay.TimeStampGroup = :old.DateStamp
            and tblPingMessGroupedByDay.MesslinieID = :old.MesslinieID;
  end if;
      
END;
/

-- #New: 3.1490;22.10.2019;S.Gueth
CREATE OR REPLACE TRIGGER PingMessDaily_Insert
AFTER INSERT
ON tblPingMess
FOR EACH ROW
DECLARE
 l_exst number(1);
 pingMinNew NUMBER(6,0);
 pingMaxNew NUMBER(6,0);
BEGIN
select case
       when exists(SELECT 1 FROM tblPingMessGroupedByDay Where tblPingMessGroupedByDay.TimeStampGroup = :new.DateStamp and tblPingMessGroupedByDay.MesslinieID = :new.MesslinieID)
       then 1          
       else 0           
      END into l_exst
from dual;      
if l_exst = 1 
  then                              
      UPDATE tblPingMessGroupedByDay
      SET PingAvg_Avg = ((PingAvg_Avg * MessAnzahl + :new.PingAvg) / (MessAnzahl + 1))
         ,MessAnzahl = (MessAnzahl + 1)
         ,PingAvg_Min = case when (PingAvg_Min > :new.PingAvg) then :new.PingAvg else PingAvg_Min end
         ,PingAvg_Max = case when (PingAvg_Max < :new.PingAvg) then :new.PingAvg  else PingAvg_Max end		   
      WHERE 
        tblPingMessGroupedByDay.TimeStampGroup = :new.DateStamp AND 
        tblPingMessGroupedByDay.MesslinieID = :new.MesslinieID;
  else
    INSERT INTO tblPingMessGroupedByDay
           (MessAnzahl
           ,TimeStampGroup
           ,DateTimeStamp
           ,MesslinieID
           ,PingAvg_Min
           ,PingAvg_Max
           ,PingAvg_Avg)
     VALUES
           (1
           ,:new.DateStamp
           ,:new.DateTimeStamp
           ,:new.MesslinieID
           ,:new.PingAvg
           ,:new.PingAvg
           ,:new.PingAvg);
   end if;
END;
/


ALTER TABLE TBLCOMPUTER MODIFY COMPUTERNAME VARCHAR2(250);
/

