CREATE TABLE tblChartTypes
(
  ChartTypeID NUMBER(10, 0) NOT NULL,
  ChartType VARCHAR2(50), 
  CONSTRAINT tblChartTypes_PK PRIMARY KEY (ChartTypeID)
);
INSERT INTO tblChartTypes (ChartTypeID, ChartType) VALUES (1, 'BarChart');
INSERT INTO tblChartTypes (ChartTypeID, ChartType) VALUES (2, 'AreaChart');
INSERT INTO tblChartTypes (ChartTypeID, ChartType) VALUES (3, 'LineChart');
INSERT INTO tblChartTypes (ChartTypeID, ChartType) VALUES (21, 'SplineChart');
INSERT INTO tblChartTypes (ChartTypeID, ChartType) VALUES (22, 'SplineAreaChart');


CREATE TABLE tblComputer
(
  ComputerID NUMBER(6, 0) NOT NULL,
  ComputerName VARCHAR2(250) NOT NULL, 
  CONSTRAINT tblComputer_PK PRIMARY KEY (ComputerID)
);
CREATE UNIQUE INDEX tblComputer_ComputerName ON tblComputer (ComputerName);


CREATE TABLE tblComputerDetails
(
  ComputerDetailID NUMBER(10, 0) NOT NULL,
  ComputerID  NUMBER(6, 0) NOT NULL, 
  DetailDatum DATE NOT NULL,
  OSVersion   VARCHAR2(100),
  IEVersion   VARCHAR2( 50),
  JavaVersion VARCHAR2( 50),
  TCEVersion  VARCHAR2(100),
  UGVersion   VARCHAR2(100),
  CPUTyp      VARCHAR2(100),
  RAMSizeMB   NUMBER(10, 0),
  GFXTyp      VARCHAR2(100),
  GFXBios     VARCHAR2( 50),
  GFXTreiber  VARCHAR2(100),
  CONSTRAINT tblComputerDetails_PK PRIMARY KEY (ComputerDetailID)
);
CREATE INDEX tblComputerDetails_ComputerID ON tblComputerDetails (ComputerID);
CREATE INDEX tblComputerDetails_DetailDatum ON tblComputerDetails (DetailDatum);


CREATE TABLE tblEvents
(
  EventID NUMBER(10, 0) NOT NULL,
  EventDate      DATE NOT NULL,
  EventTimeBegin DATE NOT NULL,
  EventTimeEnd   DATE NOT NULL,
  MesslinieID     NUMBER(10, 0),
  EventTitel     VARCHAR2(255),
  EventText      CLOB,
  EintragVon     VARCHAR2(50),
  CONSTRAINT tblEvents_PK PRIMARY KEY (EventID)
);
CREATE INDEX tblEvents_EventDate ON tblEvents (EventDate);
CREATE INDEX tblEvents_EventTimeBegin ON tblEvents (EventTimeBegin);
CREATE INDEX tblEvents_EventTimeEnd ON tblEvents (EventTimeEnd);


CREATE TABLE tblFilter
(
  FilterID NUMBER(10, 0) NOT NULL,
  FilterName     VARCHAR2(50),
  UserLimitMin   NUMBER(6, 0),
  UserLimitMax   NUMBER(6, 0),
  StdevLimitPercentMin  NUMBER(3, 0),
  StdevLimitPercentMax  NUMBER(3, 0),
  DaysWithEventsOnly    NUMBER(1, 0),
  DaysWithoutEventsOnly NUMBER(1, 0),
  CONSTRAINT tblFilter_PK PRIMARY KEY (FilterID)
);


CREATE TABLE tblImports
(
  ImportName     VARCHAR2(50) NOT NULL,
  ImportType     NUMBER(10, 0),
  SourcePath     VARCHAR2(255),
  FileMask       VARCHAR2(255),
  MesslinieID     NUMBER(10, 0) NOT NULL,
  MessungID       NUMBER(10, 0) NOT NULL,
  LastTimestamp  DATE,
  Enabled        NUMBER(6, 0),
  CONSTRAINT tblImports_PK PRIMARY KEY (ImportName)
);


CREATE TABLE tblImportTypes
(
  ImportTypeID NUMBER(10, 0) NOT NULL,
  ImportType   VARCHAR2(50) NOT NULL,
  CONSTRAINT tblImportTypes_PK PRIMARY KEY (ImportTypeID)
);
INSERT INTO tblImportTypes (ImportTypeID, ImportType) VALUES (0, 'deaktiviert');
INSERT INTO tblImportTypes (ImportTypeID, ImportType) VALUES (1, 'PerformanceLog');
INSERT INTO tblImportTypes (ImportTypeID, ImportType) VALUES (2, 'PerformanceLog mit UserCount');
INSERT INTO tblImportTypes (ImportTypeID, ImportType) VALUES (3, 'PING-Statistik');
INSERT INTO tblImportTypes (ImportTypeID, ImportType) VALUES (4, 'SysLogs');
INSERT INTO tblImportTypes (ImportTypeID, ImportType) VALUES (6, 'Startzeiten');
INSERT INTO tblImportTypes (ImportTypeID, ImportType) VALUES (7, 'Workflow');


CREATE TABLE tblLineStyles
(
  LineStyleID NUMBER(10, 0) NOT NULL,
  LineStyle   VARCHAR2(50) NOT NULL,
  CONSTRAINT tblLineStyles_PK PRIMARY KEY (LineStyleID)
);
INSERT INTO tblLineStyles (LineStyleID, LineStyle) VALUES (0, 'Solid');
INSERT INTO tblLineStyles (LineStyleID, LineStyle) VALUES (1, 'Dash');
INSERT INTO tblLineStyles (LineStyleID, LineStyle) VALUES (2, 'DashDot');
INSERT INTO tblLineStyles (LineStyleID, LineStyle) VALUES (3, 'DashDotDot');
INSERT INTO tblLineStyles (LineStyleID, LineStyle) VALUES (4, 'Dot');


CREATE TABLE tblMesswerte
(
  MesswertID NUMBER(10, 0) NOT NULL,
  DateTimeStamp  DATE NOT NULL,
  Wert01 NUMBER,
  Wert02 NUMBER,
  Wert03 NUMBER,
  Wert04 NUMBER,
  Wert05 NUMBER,
  Wert06 NUMBER,
  Wert07 NUMBER,
  Wert08 NUMBER,
  Wert09 NUMBER,
  Wert10 NUMBER,
  Wert11 NUMBER,
  Wert12 NUMBER,
  Wert13 NUMBER,
  Wert14 NUMBER,
  Wert15 NUMBER,
  Wert16 NUMBER,
  Wert17 NUMBER,
  Wert18 NUMBER,
  Wert19 NUMBER,
  Wert20 NUMBER,
  CONSTRAINT tblMesswerte_PK PRIMARY KEY (MesswertID)
);
CREATE INDEX tblMesswerte_DateTimeStamp ON tblMesswerte (DateTimeStamp);


CREATE TABLE tblMesswerteConfig
(
  MesswertFeldname VARCHAR2(50) NOT NULL,
  MesswertName     VARCHAR2(50) NOT NULL,
  MesswertAktiv    NUMBER(1, 0),
  YRangeMin        NUMBER,
  YRangeMax        NUMBER,
  LineColor        VARCHAR2(20),
  LineThickness    NUMBER(10, 0),
  LineStyleID      NUMBER(10, 0),
  CONSTRAINT tblMesswerteConfig_PK PRIMARY KEY (MesswertFeldname)
);
CREATE INDEX tblMesswerteConfig_LineStyleID ON tblMesswerteConfig (LineStyleID);
INSERT INTO tblMesswerteConfig (MesswertFeldname, MesswertName, MesswertAktiv, YRangeMin, YRangeMax, LineColor, LineThickness, LineStyleID) VALUES ('Wert01', 'Wert01', 0, 0, 0, '', 0, 0);
INSERT INTO tblMesswerteConfig (MesswertFeldname, MesswertName, MesswertAktiv, YRangeMin, YRangeMax, LineColor, LineThickness, LineStyleID) VALUES ('Wert02', 'Wert02', 0, 0, 0, '', 0, 0);
INSERT INTO tblMesswerteConfig (MesswertFeldname, MesswertName, MesswertAktiv, YRangeMin, YRangeMax, LineColor, LineThickness, LineStyleID) VALUES ('Wert03', 'Wert03', 0, 0, 0, '', 0, 0);
INSERT INTO tblMesswerteConfig (MesswertFeldname, MesswertName, MesswertAktiv, YRangeMin, YRangeMax, LineColor, LineThickness, LineStyleID) VALUES ('Wert04', 'Wert04', 0, 0, 0, '', 0, 0);
INSERT INTO tblMesswerteConfig (MesswertFeldname, MesswertName, MesswertAktiv, YRangeMin, YRangeMax, LineColor, LineThickness, LineStyleID) VALUES ('Wert05', 'Wert05', 0, 0, 0, '', 0, 0);
INSERT INTO tblMesswerteConfig (MesswertFeldname, MesswertName, MesswertAktiv, YRangeMin, YRangeMax, LineColor, LineThickness, LineStyleID) VALUES ('Wert06', 'Wert06', 0, 0, 0, '', 0, 0);
INSERT INTO tblMesswerteConfig (MesswertFeldname, MesswertName, MesswertAktiv, YRangeMin, YRangeMax, LineColor, LineThickness, LineStyleID) VALUES ('Wert07', 'Wert07', 0, 0, 0, '', 0, 0);
INSERT INTO tblMesswerteConfig (MesswertFeldname, MesswertName, MesswertAktiv, YRangeMin, YRangeMax, LineColor, LineThickness, LineStyleID) VALUES ('Wert08', 'Wert08', 0, 0, 0, '', 0, 0);
INSERT INTO tblMesswerteConfig (MesswertFeldname, MesswertName, MesswertAktiv, YRangeMin, YRangeMax, LineColor, LineThickness, LineStyleID) VALUES ('Wert09', 'Wert09', 0, 0, 0, '', 0, 0);
INSERT INTO tblMesswerteConfig (MesswertFeldname, MesswertName, MesswertAktiv, YRangeMin, YRangeMax, LineColor, LineThickness, LineStyleID) VALUES ('Wert10', 'Wert10', 0, 0, 0, '', 0, 0);
INSERT INTO tblMesswerteConfig (MesswertFeldname, MesswertName, MesswertAktiv, YRangeMin, YRangeMax, LineColor, LineThickness, LineStyleID) VALUES ('Wert11', 'Wert11', 0, 0, 0, '', 0, 0);
INSERT INTO tblMesswerteConfig (MesswertFeldname, MesswertName, MesswertAktiv, YRangeMin, YRangeMax, LineColor, LineThickness, LineStyleID) VALUES ('Wert12', 'Wert12', 0, 0, 0, '', 0, 0);
INSERT INTO tblMesswerteConfig (MesswertFeldname, MesswertName, MesswertAktiv, YRangeMin, YRangeMax, LineColor, LineThickness, LineStyleID) VALUES ('Wert13', 'Wert13', 0, 0, 0, '', 0, 0);
INSERT INTO tblMesswerteConfig (MesswertFeldname, MesswertName, MesswertAktiv, YRangeMin, YRangeMax, LineColor, LineThickness, LineStyleID) VALUES ('Wert14', 'Wert14', 0, 0, 0, '', 0, 0);
INSERT INTO tblMesswerteConfig (MesswertFeldname, MesswertName, MesswertAktiv, YRangeMin, YRangeMax, LineColor, LineThickness, LineStyleID) VALUES ('Wert15', 'Wert15', 0, 0, 0, '', 0, 0);
INSERT INTO tblMesswerteConfig (MesswertFeldname, MesswertName, MesswertAktiv, YRangeMin, YRangeMax, LineColor, LineThickness, LineStyleID) VALUES ('Wert16', 'Wert16', 0, 0, 0, '', 0, 0);
INSERT INTO tblMesswerteConfig (MesswertFeldname, MesswertName, MesswertAktiv, YRangeMin, YRangeMax, LineColor, LineThickness, LineStyleID) VALUES ('Wert17', 'Wert17', 0, 0, 0, '', 0, 0);
INSERT INTO tblMesswerteConfig (MesswertFeldname, MesswertName, MesswertAktiv, YRangeMin, YRangeMax, LineColor, LineThickness, LineStyleID) VALUES ('Wert18', 'Wert18', 0, 0, 0, '', 0, 0);
INSERT INTO tblMesswerteConfig (MesswertFeldname, MesswertName, MesswertAktiv, YRangeMin, YRangeMax, LineColor, LineThickness, LineStyleID) VALUES ('Wert19', 'Wert19', 0, 0, 0, '', 0, 0);
INSERT INTO tblMesswerteConfig (MesswertFeldname, MesswertName, MesswertAktiv, YRangeMin, YRangeMax, LineColor, LineThickness, LineStyleID) VALUES ('Wert20', 'Wert20', 0, 0, 0, '', 0, 0);


CREATE TABLE tblMessungen
(
  MessungID           NUMBER(6, 0) NOT NULL,
  AchsenBeschriftung  VARCHAR2(255)   NOT NULL,
  AchsenMaximum       NUMBER(6, 0) NOT NULL,
  MessungName         VARCHAR2(255)   NOT NULL,
  CONSTRAINT tblMessungen_PK PRIMARY KEY (MessungID)
);
INSERT INTO tblMessungen (MessungID,AchsenBeschriftung, AchsenMaximum, MessungName) VALUES (0,'default',0, 'default');


CREATE TABLE tblPerfMess
(
  PerfMessID     NUMBER(10, 0) NOT NULL,
  MessungID      NUMBER(6, 0) NOT NULL,
  DateTimeStamp  DATE NOT NULL,
  ComputerID     NUMBER(6, 0) NOT NULL, 
  MesslinieID     NUMBER(10, 0) NOT NULL,
  MessNummer     NUMBER(6, 0),
  LoadUpdCpuReal FLOAT(7),
  LoadUpdCpu     FLOAT(7),
  TotalReal      FLOAT(7),
  UGMGRReal      FLOAT(7),
  PDIReal        FLOAT(7),
  SQLReal        FLOAT(7),
  DateStamp      VARCHAR2(10),
  CONSTRAINT tblPerfMess_PK PRIMARY KEY (PerfMessID)
);
CREATE INDEX tblPerfMess_DateTimeStamp ON tblPerfMess (DateTimeStamp);
CREATE INDEX tblPerfMess_MessID_Date ON tblPerfMess (MessungID, DateTimeStamp);
CREATE INDEX tblPerfMess_MessID_Num_Date ON tblPerfMess (MessungID, MessNummer, DateTimeStamp);
CREATE INDEX tblPerf_DateStamp ON tblPerfMess (DateStamp);
CREATE INDEX tblPerf_DateStamp_MessungID ON tblPerfMess (DateStamp, MesslinieID);


CREATE TABLE tblPingMess
(
  PingMessID     NUMBER(10, 0) NOT NULL,
  DateTimeStamp  DATE NOT NULL,
  MesslinieID     NUMBER(10, 0) NOT NULL,
  PingSent       NUMBER(6, 0) NOT NULL,
  PingRecv       NUMBER(6, 0) NOT NULL,
  PingLost       NUMBER(6, 0) NOT NULL,
  PingMin        NUMBER(6, 0) NOT NULL,
  PingMax        NUMBER(6, 0) NOT NULL,
  PingAvg        NUMBER(6, 0) NOT NULL,
  DateStamp      VARCHAR2(10),
  CONSTRAINT tblPingMess_PK PRIMARY KEY (PingMessID)
);
CREATE INDEX tblPingMess_DateTimeStamp ON tblPingMess (DateTimeStamp);
CREATE INDEX tblPingMess_MesslinieID ON tblPingMess (MesslinieID);
CREATE INDEX tblPingMess_DateTime_Avg ON tblPingMess (DateTimeStamp, PingAvg);
CREATE INDEX tblPing_DateStamp ON tblPingMess (DateStamp);
CREATE INDEX tblPing_DateStamp_PingAvg ON tblPingMess (DateStamp, PingAvg);


CREATE TABLE tblMesslinien
(
  MesslinieID    NUMBER(10, 0) NOT NULL,
  MesslinieName  VARCHAR2( 50) NOT NULL,
  Reihenfolge   NUMBER(6, 0),
  PerfMessColor VARCHAR2( 20),
  PingMessColor VARCHAR2( 20),
  Visible       NUMBER(6, 0),
  IncludePingMess NUMBER(7, 0),
  RelatedMesslinieId NUMBER(10, 0),
  UserCountColor      VARCHAR2( 50),  
  UserCountLabel      VARCHAR2( 50), 
  IncludeStartzeiten  NUMBER(6, 0),      
  IsWorkflow          NUMBER(6, 0),  
  WorklflowColor      VARCHAR2( 20),    
  WorklflowErrorColor VARCHAR2( 20), 
  KPI_OK              FLOAT(7),         
  KPI_ERR             FLOAT(7),    
  KPIUser_OK          FLOAT(7),         
  KPIUser_ERR         FLOAT(7),  
  GroupAction         VARCHAR2( 50),
  GroupWorldregion    VARCHAR2( 50),  
  groupCountry        VARCHAR2( 50),
  groupSite           VARCHAR2( 50),
  groupDepartement    VARCHAR2( 50),
  GroupCustom         VARCHAR2( 50),
  CONSTRAINT tblMesslinien_PK PRIMARY KEY (MesslinieID)
);
INSERT INTO tblMesslinien (MesslinieID, MesslinieName, Reihenfolge, PerfMessColor, PingMessColor) VALUES (1, 'Test Messlinie', 0, 'Blue', 'Yellow');

CREATE INDEX tblMess_ID ON tblMesslinien (MesslinieID);

-- #New: 3.1447;19.01.2018;S.Gueth
  CREATE TABLE tblWorkflowsMess
  (
          WorkflowMessID     NUMBER(10, 0),
          DateTimeSpanStart  DATE,
		  DateTimeSpanEnd    DATE,
          MesslinieID        NUMBER(10, 0),
		  WorkflowTotal      NUMBER(10, 0),
		  WorkflowErrors     NUMBER(10, 0),
		  WorkflowErrorQuote FLOAT(7),
          CONSTRAINT tblWorkflowMess_PK PRIMARY KEY (WorkflowMessID)
  );
  CREATE INDEX tblWorkflowMess_PK                                                  ON tblWorkflowsMess (WorkflowMessID);
  CREATE INDEX tblWorkflowsMess_IDX_DTSStart                                       ON tblWorkflowsMess (DateTimeSpanStart);
  CREATE INDEX tblWorkflowsMess_IDX_DTSEnd                                         ON tblWorkflowsMess (DateTimeSpanEnd);
  CREATE INDEX tblWorkflowsMess_IDX_MID                                            ON tblWorkflowsMess (MesslinieID); 
  CREATE INDEX tblWorkflowsMess_IDX_MStartEnd                                      ON tblWorkflowsMess (MesslinieID, DateTimeSpanStart, DateTimeSpanEnd); 



  CREATE TABLE tblStartzeiten
  (
          STARTZEITID         NUMBER(10, 0),
          DATETIMESTAMP       DATE,
          CLIENTNAME          VARCHAR2( 25),
          USERNAME            VARCHAR2( 25),
          SIDT_SECONDS        FLOAT(7),
          TCLOGIN_SECONDS     FLOAT(7),
          NXSTART_SECONDS     FLOAT(7),
          TCDB                VARCHAR2( 10),
          TIERS               NUMBER(6, 0),
          MESSLINIEID         NUMBER(6, 0),
          RESULTSXML          VARCHAR2( 512),
          CONSTRAINT TBLSTARTZEITEN_PK PRIMARY KEY (STARTZEITID)
  );
  CREATE INDEX IDX_DATETIMESTAMP ON tblStartzeiten (DATETIMESTAMP);
  CREATE INDEX STARTZEIT_DTS ON tblStartzeiten (STARTZEITID, DATETIMESTAMP);

CREATE TABLE tblUserCount
(
  UserCountID    NUMBER(10, 0) NOT NULL,
  DateTimeStamp  DATE NOT NULL,
  UserCount      NUMBER(6, 0) NOT NULL,
  MesslinieID    NUMBER(6, 0), 
  DateStamp      VARCHAR2(10),
  CONSTRAINT tblUserCount_PK PRIMARY KEY (UserCountID)
);
CREATE INDEX tblUserCount_DateTimeStamp ON tblUserCount (DateTimeStamp);
CREATE INDEX tblUser_DateStamp ON tblUserCount (DateStamp);
CREATE INDEX tblUser_DateStamp_DATETIMESTAMP ON tblUserCount (DateStamp, DATETIMESTAMP);


-- #New: 3.1490;21.10.2019;S.Gueth
CREATE TABLE tblPingMessGroupedByDay
  (
          MessAnzahl        NUMBER(6, 0) ,
		  TimeStampGroup    VARCHAR2(10),
          DateTimeStamp     DATE NOT NULL,
          MesslinieID       NUMBER(6, 0),
          PingAvg_Min       NUMBER(6, 0) NOT NULL,
          PingAvg_Max       NUMBER(6, 0) NOT NULL,
          PingAvg_Avg       FLOAT(7) NOT NULL
  );

CREATE INDEX PingGrByDay_TST ON tblPingMessGroupedByDay (TimeStampGroup);
CREATE INDEX PingGrByDay_MesslinieID ON tblPingMessGroupedByDay (MesslinieID);
CREATE INDEX PingGrByDay_DTS ON tblPingMessGroupedByDay (DateTimeStamp);
CREATE INDEX PingGrByDay_TST_MessID ON tblPingMessGroupedByDay (TimeStampGroup,MesslinieID);


-- #New: 3.1491;27.02.2020;S.Gueth
Create View PLMPerfSummaryView as
(SELECT mess.groupAction as ACTION,
perf.DateTimeStamp as TIMESTAMPSTART,
NULL as TIMESTAMPEND,
mess.GroupWorldregion as WORLDREGION,
mess.GroupCountry as COUNTRY,
mess.GroupSite as SITE,
mess.GroupDepartement as DEPARTEMENT,
perf.LoadUpdCpuReal as DURATIONSEC,
'' as WHERECONDITION
  FROM tblPerfMess perf inner join tblMesslinien mess on perf.MesslinieID = mess.MesslinieID)
  WHERE mess.VISIBLE = 1
UNION ALL
(  SELECT 'Ping' as ACTION,
Min(ping.DateTimeStamp) as TIMESTAMPSTART,
Max(ping.DateTimeStamp) as TIMESTAMPEND,
mess.GroupWorldregion as WORLDREGION,
mess.GroupCountry as COUNTRY,
mess.GroupSite as SITE,
mess.GroupDepartement as DEPARTEMENT,
Avg(ping.PingAvg)/1000 as DURATIONSEC,
'' as WHERECONDITION
  FROM tblPingMess ping inner join tblMesslinien mess on ping.MesslinieID = mess.MesslinieID
  WHERE mess.VISIBLE = 1
  Group By ping.DateStamp, mess.GroupWorldregion, mess.GroupCountry, mess.GroupSite, mess.GroupDepartement);



-- #New: 3.1490;22.10.2019;S.Gueth
CREATE OR REPLACE TRIGGER PingMessDaily_Delete
AFTER DELETE
ON tblPingMess
FOR EACH ROW
DECLARE
 l_exst number(1);
BEGIN
select case
       when exists(SELECT 1 FROM tblPingMessGroupedByDay Where tblPingMessGroupedByDay.TimeStampGroup = :old.DateStamp and tblPingMessGroupedByDay.MesslinieID = :old.MesslinieID and tblPingMessGroupedByDay.MessAnzahl > 1)
       then 1          
       else 0           
      END into l_exst
from dual;
      
  if l_exst = 1 
  then
    	UPDATE tblPingMessGroupedByDay
              SET PingAvg_Avg = (PingAvg_Avg * MessAnzahl - :old.PingAvg) / (MessAnzahl - 1)
                 ,MessAnzahl = MessAnzahl - 1
              WHERE 
                tblPingMessGroupedByDay.TimeStampGroup = :old.DateStamp AND 
                tblPingMessGroupedByDay.MesslinieID = :old.MesslinieID;
  else
     DELETE FROM 
            tblPingMessGroupedByDay
            WHERE  
            tblPingMessGroupedByDay.TimeStampGroup = :old.DateStamp
            and tblPingMessGroupedByDay.MesslinieID = :old.MesslinieID;
  end if;
      
END;




-- #New: 3.1490;22.10.2019;S.Gueth
CREATE OR REPLACE TRIGGER PingMessDaily_Insert
AFTER INSERT
ON tblPingMess
FOR EACH ROW
DECLARE
 l_exst number(1);
 pingMinNew NUMBER(6,0);
 pingMaxNew NUMBER(6,0);
BEGIN
select case
       when exists(SELECT 1 FROM tblPingMessGroupedByDay Where tblPingMessGroupedByDay.TimeStampGroup = :new.DateStamp and tblPingMessGroupedByDay.MesslinieID = :new.MesslinieID)
       then 1          
       else 0           
      END into l_exst
from dual;      
if l_exst = 1 
  then                              
      UPDATE tblPingMessGroupedByDay
      SET PingAvg_Avg = ((PingAvg_Avg * MessAnzahl + :new.PingAvg) / (MessAnzahl + 1))
         ,MessAnzahl = (MessAnzahl + 1)
         ,PingAvg_Min = case when (PingAvg_Min > :new.PingAvg) then :new.PingAvg else PingAvg_Min end
         ,PingAvg_Max = case when (PingAvg_Max < :new.PingAvg) then :new.PingAvg  else PingAvg_Max end		   
      WHERE 
        tblPingMessGroupedByDay.TimeStampGroup = :new.DateStamp AND 
        tblPingMessGroupedByDay.MesslinieID = :new.MesslinieID;
  else
    INSERT INTO tblPingMessGroupedByDay
           (MessAnzahl
           ,TimeStampGroup
           ,DateTimeStamp
           ,MesslinieID
           ,PingAvg_Min
           ,PingAvg_Max
           ,PingAvg_Avg)
     VALUES
           (1
           ,:new.DateStamp
           ,:new.DateTimeStamp
           ,:new.MesslinieID
           ,:new.PingAvg
           ,:new.PingAvg
           ,:new.PingAvg);
   end if;
END;