Print ''                
Print '-------------------------------------------------------------------------'
Print ' using Database: PLMPerfAnalyse_tcpord'
Print ' Table         : [viewPingMessGroupedByDay]'
Print ' Creation Date : 18.10.2019'
Print ' Autor         : S.G?th'
Print '-------------------------------------------------------------------------'

use [PLMPerfAnalyse_tcpord]

Declare @MyActionMsg1 nvarchar (max)
Declare @MyTableName nvarchar (max)
set @MyTableName='viewPingMessGroupedByDay'
DECLARE @ExecuteSQLstr nvarchar(max)

declare @indexNrCur  int
declare @indexNrEnd  int
declare @indexNrStr       varchar(32)
declare @IndexName        varchar(max)
declare @ProcStateColName varchar(max)
set @indexNrEnd = 10


--------------------------------------------------------------------------------
-- verzweigen auf TableCreate: oder TableUpdate:
  if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[viewPingMessGroupedByDay]'))
  BEGIN
   DROP VIEW viewPingMessGroupedByDay
  END

  GO

  CREATE VIEW viewPingMessGroupedByDay 
  AS
  SELECT 
	Count(PingMessID) AS MessAnzahl, 
	DateStamp AS TimeStampGroup, 
	Min(DateTimeStamp) AS DateTimeStamp, 
	MesslinieID, 
	ROUND(MIN(PingAvg),3) AS PingAvg_Min, 
	ROUND(MAX(PingAvg),3) AS PingAvg_Max, 
	ROUND(AVG(PingAvg),3) AS PingAvg_Avg
  FROM tblPingMess
  GROUP BY 
	DateStamp, 
	MesslinieID 

 GO

  --EXECUTE JF_IndexCheckCreateDef   'viewPingMessGroupedByDay_IDX_TimeStampGroup',               'viewPingMessGroupedByDay', 'TimeStampGroup'
  --EXECUTE JF_IndexCheckCreateDef   'viewPingMessGroupedByDay_IDX_MesslinieID',				    'viewPingMessGroupedByDay', 'MesslinieID' 
  --EXECUTE JF_IndexCheckCreateDef   'viewPingMessGroupedByDay_IDX_DateTimeStamp',				'viewPingMessGroupedByDay', 'DateTimeStamp' 
  --EXECUTE JF_IndexCheckCreateDef   'viewPingMessGroupedByDay_IDX_TimeStampGroup_MesslinieID',   'viewPingMessGroupedByDay', 'TimeStampGroup, MesslinieID'

 Print ('   |-> Done on Database: PLMPerfAnalyse_tcpord')
 Print '------------------------------------------------------------------------'

GO
