Print ''                
Print '-------------------------------------------------------------------------'
Print ' using Database: PLMPerfAnalyse_tcpord'
Print ' Trigger for   : [tblPingMess]'
Print ' Creation Date : 18.10.2019'
Print ' Autor         : S.G?th'
Print '-------------------------------------------------------------------------'

use [PLMPerfAnalyse_tcpord]

GO
IF EXISTS (SELECT * FROM sys.objects WHERE [name] = N'PingMessDaily_Insert' AND [type] = 'TR')
BEGIN
      DROP TRIGGER PingMessDaily_Insert
END

GO
CREATE TRIGGER PingMessDaily_Insert
ON tblPingMess
AFTER INSERT
AS
BEGIN

 if EXISTS (SELECT 1 FROM tblPingMessGroupedByDay Where tblPingMessGroupedByDay.TimeStampGroup = (SELECT TOP 1  inserted.DateStamp FROM inserted) and tblPingMessGroupedByDay.MesslinieID = (SELECT TOP 1  inserted.MesslinieID FROM inserted))
   BEGIN    
		UPDATE tblPingMessGroupedByDay
		SET MessAnzahl = MessAnzahl + 1
		   ,PingAvg_Min = CASE WHEN PingAvg_Min > (SELECT TOP 1  inserted.PingAvg FROM inserted) THEN (SELECT TOP 1  inserted.PingAvg FROM inserted) ELSE PingAvg_Min END
		   ,PingAvg_Max = CASE WHEN PingAvg_Max < (SELECT TOP 1  inserted.PingAvg FROM inserted) THEN (SELECT TOP 1  inserted.PingAvg FROM inserted) ELSE PingAvg_Max END
		   ,PingAvg_Avg = ROUND((PingAvg_Avg + (SELECT TOP 1  inserted.PingAvg FROM inserted)) / 2, 3)
		WHERE 
		  tblPingMessGroupedByDay.TimeStampGroup = (SELECT TOP 1  inserted.DateStamp FROM inserted) AND 
		  tblPingMessGroupedByDay.MesslinieID = (SELECT TOP 1  inserted.MesslinieID FROM inserted)
   END
ELSE
  BEGIN
    INSERT INTO tblPingMessGroupedByDay
           ([MessAnzahl]
           ,[TimeStampGroup]
           ,[DateTimeStamp]
           ,[MesslinieID]
           ,[PingAvg_Min]
           ,[PingAvg_Max]
           ,[PingAvg_Avg])
     VALUES
           (1
           ,(SELECT TOP 1  inserted.DateStamp FROM inserted)
           ,(SELECT TOP 1  inserted.DateTimeStamp FROM inserted)
           ,(SELECT TOP 1  inserted.MesslinieID FROM inserted)
           ,(SELECT TOP 1  inserted.PingAvg FROM inserted)
           ,(SELECT TOP 1  inserted.PingAvg FROM inserted)
           ,(SELECT TOP 1  inserted.PingAvg FROM inserted))
  END
END


GO
IF EXISTS (SELECT * FROM sys.objects WHERE [name] = N'PingMessDaily_Delete' AND [type] = 'TR')
BEGIN
      DROP TRIGGER PingMessDaily_Delete
END

GO
CREATE TRIGGER PingMessDaily_Delete
ON tblPingMess
AFTER DELETE
AS
BEGIN

 if EXISTS (SELECT 1 FROM tblPingMessGroupedByDay Where tblPingMessGroupedByDay.TimeStampGroup = (SELECT TOP 1  deleted.DateStamp FROM deleted) and tblPingMessGroupedByDay.MesslinieID = (SELECT TOP 1  deleted.MesslinieID FROM deleted) and tblPingMessGroupedByDay.MessAnzahl > 1)
   BEGIN    
		UPDATE tblPingMessGroupedByDay
		SET MessAnzahl = MessAnzahl - 1
		   ,PingAvg_Avg = ROUND(PingAvg_Avg * 2 - (SELECT TOP 1  deleted.PingAvg FROM deleted), 3)
		WHERE 
		  tblPingMessGroupedByDay.TimeStampGroup = (SELECT TOP 1  deleted.DateStamp FROM deleted) AND 
		  tblPingMessGroupedByDay.MesslinieID = (SELECT TOP 1  deleted.MesslinieID FROM deleted)
   END
ELSE
  BEGIN
    DELETE FROM 
	  tblPingMessGroupedByDay
    WHERE  
	  tblPingMessGroupedByDay.TimeStampGroup = (SELECT TOP 1  deleted.DateStamp FROM deleted) 
	  and tblPingMessGroupedByDay.MesslinieID = (SELECT TOP 1  deleted.MesslinieID FROM deleted)
  END
END


--------------------------------------------------------------------------------
EndeExit:
 Print ('   |-> Done on Database: PLMPerfAnalyse_tcpord')
 Print '------------------------------------------------------------------------'

GO
