Print ''                
Print '-------------------------------------------------------------------------'
Print ' using Database: PLMPerfAnalyse_tcpord'
Print ' Table         : [tblPingMess]'
Print ' Creation Date : 13.11.2012'
Print ' Autor         : S.G?th'
Print '-------------------------------------------------------------------------'

use [PLMPerfAnalyse_tcpord]

Declare @MyActionMsg1 nvarchar (max)
Declare @MyTableName nvarchar (max)
set @MyTableName='tblPingMess'
DECLARE @ExecuteSQLstr nvarchar(max)

declare @indexNrCur  int
declare @indexNrEnd  int
declare @indexNrStr       varchar(32)
declare @IndexName        varchar(max)
declare @ProcStateColName varchar(max)
set @indexNrEnd = 10


--------------------------------------------------------------------------------
-- verzweigen auf TableCreate: oder TableUpdate:
if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[tblPingMess]') and OBJECTPROPERTY(id, N'IsUserTable') = 1)
  BEGIN
   goto TableUpdate
  END
ELSE
  BEGIN
   goto TableCreate
  END

--------------------------------------------------------------------------------
TableCreate:
  set @MyActionMsg1=
      '-- Table: [tblPingMess] dose not exist and will be created new'

  Print (@MyActionMsg1)


  CREATE TABLE tblPingMess
  (
          [PingMessID]        int NOT NULL,
          [DateTimeStamp]     datetime2 NOT NULL,
          [MesslinieID]       int NOT NULL,
          [PingSent]          int NOT NULL,
          [PingRecv]          int NOT NULL,
          [PingLost]          int NOT NULL,
          [PingMin]           int NOT NULL,
          [PingMax]           int NOT NULL,
          [PingAvg]           int NOT NULL,
		  [DateStamp]          nvarchar(10),
          CONSTRAINT tblPingMess_PK PRIMARY KEY ([PingMessID])
  )
  ON [PRIMARY]

  goto CheckCreateIndex

--------------------------------------------------------------------------------
TableUpdate:

  set @MyActionMsg1=
       '-- Table: [' + @MyTableName + '] exist and will be updated'
  Print (@MyActionMsg1)

  Declare @ColumeName nvarchar (256)
  Declare @ColumeNameOld nvarchar (256)
  Declare @ColumeNameNew nvarchar (256)
  Declare @ExecuteStr nvarchar (max)


  set @ColumeName='DateStamp'
  if (Select Coalesce(Col_length(@MyTableName,@ColumeName),0)) = 0
    begin
      print ('Create Column:' + @ColumeName +  ' DateStamp (new 10.10.2019 S.Gueth)')
      set @ExecuteStr='ALTER TABLE [dbo].[' + @MyTableName + '] ADD [' + @ColumeName +'] nvarchar(10) COLLATE Latin1_General_CS_AS NULL'
      execute (@ExecuteStr)
	  set @ExecuteStr='Update [dbo].[' + @MyTableName + '] set [DateStamp] = CAST(DATEPART(yyyy, [DateTimeStamp]) as nvarchar) + ''-'' + RIGHT(''00'' + CAST(DATEPART(mm, [DateTimeStamp]) as nvarchar), 2)+ ''-'' + RIGHT(''00'' +CAST(DATEPART(dd, [DateTimeStamp]) as nvarchar), 2)'
      execute (@ExecuteStr)
    end




goto CheckCreateIndex

--------------------------------------------------------------------------------
CheckCreateIndex:

  EXECUTE JF_PrimKeyCheckCreateDef 'tblPingMess_pk',							@MyTableName, 'PingMessID'
  EXECUTE JF_IndexCheckCreateDef   'tblPingMess_IDX_DateTimeStamp',				@MyTableName, 'DateTimeStamp'
  EXECUTE JF_IndexCheckCreateDef   'tblPingMess_IDX_MesslinieID',				@MyTableName, 'MesslinieID' 
  EXECUTE JF_IndexCheckCreateDef   'tblPingMess_IDX_DateTimeStamp_PingAvg',     @MyTableName, 'DateTimeStamp, PingAvg'
  EXECUTE JF_IndexCheckCreateDef   'tblPingMess_IDX_DateStamp_PingAvg',         @MyTableName, 'DateStamp, PingAvg'
  EXECUTE JF_IndexCheckCreateDef   'tblPingMess_IDX_DateStamp',                 @MyTableName, 'DateStamp' 

--------------------------------------------------------------------------------
EndeExit:
 Print ('   |-> Done on Database: PLMPerfAnalyse_tcpord')
 Print '------------------------------------------------------------------------'

GO
