Print ''
Print '-------------------------------------------------------------------------'
Print ' using Database: #DB_N#'
Print ' Procedures    : [REPORTS]'
Print ' Creation Date : 22.03.2006'
Print ' Autor         : J.Feuerstein'

use [#DB_N#]

Print ''
Print ' '
Print '-------------------------------------------------------------------------'
Print '--------------------- R E P O R T S -------------------------------------'
Print '-------------------------------------------------------------------------'
Print ''

-- 26.02.2010 16:52 #temp_tbl loeschen da sonst bei abbruch die Reports nicht importiert werden koennen!!
IF (OBJECT_ID ('tempdb..##temp_tbl', N'U') IS NOT NULL) exec ('drop table ##temp_tbl')
Go


--------------------------------------------------------------------------------
--------------------------------------------------------------------------------
--------------------------------------------------------------------------------
Print '-'
Print '-- [DS_AndProcessDataForCount_UDF] --------------------------------------'
If Exists (select Name
           from sysobjects
            where Name = "DS_AndProcessDataForCount_UDF" and type = "IF")
DROP FUNCTION DS_AndProcessDataForCount_UDF
GO

CREATE FUNCTION DS_AndProcessDataForCount_UDF(@ProcessProcStateCol nvarchar(32))
-- UDF Optimiert fr Statistik Abfragen
-- 07.12.2011 with (nolock) eingefuegt
RETURNS TABLE AS
Return (
        SELECT
             ObjectFromSiteID,
             ObjectOwningSiteID,
             ObjectUgMaster_Type,
             ObjectType,
             ObjectUgMaster_FsHitCount,
             ProcStateCol01,
             ProcStateCol02,
             ProcStateCol03,
             ProcStateCol04,
             ProcStateCol05,
             ProcStateCol06,
             ProcStateCol07,
             ProcStateCol08,
             ProcStateCol09,
             ProcStateColRf,
             JobControl_ObjectsProcessData_tbl_As.ProcessOnSiteID,
            -- JobControl_ObjectsProcessData_tbl_AS.ProcessState,
             JobControl_ObjectsProcessData_tbl_AS.ProcessResultCode,
             JobControl_ObjectsProcessData_tbl_AS.ProcessProcStateCol,
             JobControl_ObjectsProcessData_tbl_AS.ProcessResultHasWarning,
             JobControl_ObjectsProcessData_tbl_AS.Row_isLastRes
        FROM Objects_tbl  with (nolock)
             Left JOIN
             (SELECT Objects_tbl_ID, ProcessOnSiteID, ProcessState, ProcessResultCode, ProcessProcStateCol, ProcessResultHasWarning, Row_isLastRes
                FROM JobControl_ObjectsProcessData_tbl with (nolock)
               WHERE ProcessProcStateCol = @ProcessProcStateCol) as JobControl_ObjectsProcessData_tbl_AS
             ON (Objects_tbl.ID = JobControl_ObjectsProcessData_tbl_AS.Objects_tbl_ID)
                 where Objects_tbl.ObjectClass = 'DS'
       )
Go

--------------------------------------------------------------------------------
Print '-'
Print '-- [ReportPageNamesInit] ------------------------------------------------'
If Exists (select Name
           from sysobjects
           where Name = "ReportPageNamesInit" and type = "P")
Drop Procedure ReportPageNamesInit
GO

CREATE PROCEDURE dbo.ReportPageNamesInit
  @ReportName nvarchar(100),
  @ReportDescription nvarchar(max)
AS
BEGIN
    -- new 18.10.2010A.Becker 
    TRUNCATE TABLE dbo.ReportPageNames_temp_tbl
    INSERT INTO dbo.ReportPageNames_temp_tbl (Position, Name, Description)
                         VALUES (0, @ReportName, @ReportDescription)
    Return 1
END
GO
--------------------------------------------------------------------------------
Print '-'
Print '-- [ReportPageNamesAdd] ------------------------------------------------'
If Exists (select Name
           from sysobjects
           where Name = "ReportPageNamesAdd" and type = "P")
Drop Procedure ReportPageNamesAdd
GO

CREATE PROCEDURE dbo.ReportPageNamesAdd
  /*@Position int,*/
  @ReportPageName nvarchar(100),
  @ReportPageDescription nvarchar(max)
AS
BEGIN
    -- new 18.10.2010A.Becker
    DECLARE @Position int;
    SELECT @Position = Max(Position)+1
    FROM dbo.ReportPageNames_temp_tbl

    INSERT INTO dbo.ReportPageNames_temp_tbl (Position, Name, Description)
                         VALUES (@Position, @ReportPageName, @ReportPageDescription)
    Return 1
END
GO
--------------------------------------------------------------------------------
Print '-'
Print '-- [ReportPageNamesGet] ------------------------------------------------'
If Exists (select Name
           from sysobjects
           where Name = "ReportPageNamesGet" and type = "P")
Drop Procedure ReportPageNamesGet
GO
CREATE PROCEDURE ReportPageNamesGet
AS
BEGIN
  -- new 18.10.2010 A.Becker
  SELECT *
  FROM dbo.ReportPageNames_temp_tbl
  ORDER BY Position
END
GO

--------------------------------------------------------------------------------
-- Alte Reports aus der Datenbank lschen !!
Declare @ReportToDelete nvarchar(4000)
Declare @ReportToDeleteExce nvarchar(4000)
While (select Top(1) Name from sysobjects where Name like "Report[_]%" and type = "P")<>""
 begin
  select Top(1) @ReportToDelete=Name from sysobjects where Name like "Report[_]%" and type = "P"
  -- Print '--'
  -- Print ' Delete Report:' + @ReportToDelete
  -- Print '--'
  set @ReportToDeleteExce="Drop PROCEDURE " + @ReportToDelete
  execute (@ReportToDeleteExce)
 end
GO
--------------------------------------------------------------------------------
--------------------------------------------------------------------------------
Print '-'
Print '-- [Report_101_Objects_Datasets_Sum] ------------------------------------'
GO
CREATE PROCEDURE Report_101_Objects_Datasets_Sum
       (
        @ObjectFromSiteID nvarchar(32) ,
        @ProcStateCol nvarchar(32)
       )
AS
Begin

  DECLARE @DebugPrintOn bit
  set @DebugPrintOn = 1
  DECLARE @MyProcName nvarchar(32)
  set @MyProcName='Report_101_Objects_Datasets_Sum'
  DECLARE @ExecuteSQLstr nvarchar(max)
  -- 07.12.2011  with (nolock) eingefuegt
  set @ExecuteSQLstr = 'SELECT ' +
                       'ObjectFromSiteID          AS [SiteID] ,' +
                        ' CASE [ObjectFromSiteID] ' +
                          '  WHEN [ObjectOwningSiteID] ' +
                          '    THEN ''1-SO (SiteObj)'' ' +
                          '  ELSE   ''2-RO (ReplObj)'' ' +
                          '  END           AS [S.Or.Rep Object], ' +
                        ' CASE [ObjectUgMaster_Type] ' +
                           '  WHEN ''SP'' ' +
                           '     THEN ''1-SP (Single Parts)'' ' +
                           '     ELSE ''2-AP (Assembly)'' '  +
                           '  END                  As [O.UGMaster_Type],' +
                        ' [ObjectType]             As [Dataset Type],' +
                        ' COUNT(ObjectType)        AS [Dataset Count]' +
                        ' from [dbo].[Objects_tbl] with (nolock)' +
                        ' WHERE (ObjectClass = ''DS'')'

  if CharIndex('%', @ObjectFromSiteID)>0
   begin
    if @ObjectFromSiteID <> '%'
     -- 05.03.2011 eingefuegt um bei % unnoetigen select like zu vermeiden
     begin
      -- Suche ber [ObjectFromSiteID] mit Like Operator @ObjectFromSiteID mit Like Operator erforderlich
      set @ExecuteSQLstr = @ExecuteSQLstr +
                           ' and ([ObjectFromSiteID] like ' + '''' + @ObjectFromSiteID + '''' + ')'
     end
   end
   else
   begin
    if @ObjectFromSiteID <> ''
     -- 05.03.2011 eingefuegt um bei '' unnoetigen select zu vermeiden
     begin
      set @ExecuteSQLstr = @ExecuteSQLstr +
                          ' and ([ObjectFromSiteID] = ' + '''' + @ObjectFromSiteID + '''' + ')'
     end
   end

   /* festellung group by hat keine messbaren auswirkungen auf performance */
   set @ExecuteSQLstr = @ExecuteSQLstr +
                       ' GROUP BY ' +
                       '  ObjectFromSiteID , ObjectType , ObjectUgMaster_Type, ' +
                       
                      ' CASE [ObjectFromSiteID] ' +
                           '  WHEN [ObjectOwningSiteID] ' +
                           '    THEN ''1-SO (SiteObj)'' ' +
                           '  ELSE   ''2-RO (ReplObj)'' ' +
                           '  END , ' +
                      ' CASE ObjectUgMaster_Type ' +
                           '  WHEN ''SP'' ' +
                           '    THEN ''1-SP (Single Parts)'' ' +
                           '    ELSE ''2-AP (Assembly)'' ' +
                           '  END'

  if @DebugPrintOn = 1
  begin

   set @ExecuteSQLstr = Replace(@ExecuteSQLstr,"     "," ")
   set @ExecuteSQLstr = Replace(@ExecuteSQLstr,"    "," ")
   set @ExecuteSQLstr = Replace(@ExecuteSQLstr,"   "," ")
   set @ExecuteSQLstr = Replace(@ExecuteSQLstr,"  "," ")

   -- Clear Debug Table
   EXECUTE zzzzzDebugTbl_Empty
   EXECUTE zzzzzDebugTbl_AddDataSet @MyProcName , '@ObjectFromSiteID' , @ObjectFromSiteID
   EXECUTE zzzzzDebugTbl_AddDataSet @MyProcName , '@ProcStateCol' ,     @ProcStateCol
   EXECUTE zzzzzDebugTbl_AddDataSet @MyProcName , '@ExecuteSQLstr' ,    @ExecuteSQLstr
  end

  execute sp_executesql @ExecuteSQLstr


END
GO
--------------------------------------------------------------------------------
--------------------------------------------------------------------------------
--------------------------------------------------------------------------------

Print '-'
Print '-- [Rrt_200_ProcStatus_by_DataSets_MultiSiteYes] -------------------------------------'
If Exists (select Name
           from sysobjects
           where Name = "Rrt_200_ProcStatus_by_DataSets_MultiSiteYes" and type = "P")
Drop Procedure Rrt_200_ProcStatus_by_DataSets_MultiSiteYes
GO


CREATE PROCEDURE Rrt_200_ProcStatus_by_DataSets_MultiSiteYes
       (
        @ObjectFromSiteID nvarchar(32),
        @ProcStateCol nvarchar(14),
        @ViewFormat nvarchar(14), -- Valid Values "CountPercent" 'Count'
        @GroupDataDo bit  -- 29.09.2012 New J.Fes

       )
AS
begin
  DECLARE @DebugPrintOn bit
  set @DebugPrintOn = 1
  DECLARE @MyProcName nvarchar(32)
  set @MyProcName='Rrt_200_ProcStatus_by_DataSets_MultiSiteYes'

  DECLARE @ExecuteSQLstr nvarchar(max)
  DECLARE @TempTblName   nvarchar(32)
--   IF (OBJECT_ID ('tempdb..' + @TempTblName, N'U') IS NOT NULL) exec ('drop table ' + 'tempdb..' + @TempTblName)
  set @TempTblName = 'tempdb..##temp_tbl'
  IF (OBJECT_ID (@TempTblName, N'U') IS NOT NULL) exec ('drop table ' + @TempTblName)

  set @ExecuteSQLstr =
   'SELECT ' +
   'ObjectFromSiteID  AS [SiteID] ,'

  if @GroupDataDo = 1
  begin
  set @ExecuteSQLstr = @ExecuteSQLstr +
    ' CASE [ObjectFromSiteID] ' +
       '  WHEN [ObjectOwningSiteID] ' +
       '    THEN ''1-SO (SiteObj)'' ' +
       '  ELSE   ''2-RO (ReplObj)'' ' +
       '  END           AS [S.Or.Rep Object], ' +

    ' CASE [ObjectUgMaster_Type] ' +
       '  WHEN ''SP'' ' +
       '     THEN ''1-SP (Single Parts)'' ' +
       '     ELSE ''2-AP (Assembly)'' '  +
       '  END                  As [O.UGMaster_Type], ' +

    ' ObjectType               As [DataSet Type],'
   end

   set @ExecuteSQLstr = @ExecuteSQLstr +
    ' COUNT(ObjectType)        AS [DsSum], ' +        -- 'Datasets (sum)'
    ' Sum(CASE WHEN (['+ @ProcStateCol + '] like ''X%'')  THEN 1 ELSE 0 END)                                                  As [PStatX],' +     -- 'P.Stat:X (eXcludet)'
    ' Sum(CASE WHEN (['+ @ProcStateCol + '] like ''M%'')  THEN 1 ELSE 0 END)                                                  As [PStatM],' +     -- 'P.Stat:M (Manuell)'
    ' Sum(CASE WHEN (['+ @ProcStateCol + '] like ''N%'')  THEN 1 ELSE 0 END)                                                  As [PStatN],' +     -- 'P.Stat:N (not.Proc)'
    ' Sum(CASE WHEN (['+ @ProcStateCol + '] like ''P%'')  THEN 1 ELSE 0 END)                                                  As [PStatP],' +     -- 'P.Stat:P (in.Proc)'
    -- 30.09.2012 21:20 J.Fes AND [ProcessResultCode] <> '''' eingefuegt
    ' Sum(CASE WHEN (['+ @ProcStateCol + '] like ''D%'' AND [Row_isLastRes]=1 AND [ProcessResultCode] <> '''') THEN 1 ELSE 0 END) As [PStatD],' +     -- 'P.Stat:D (Done)'
    -- 26.09.2012 J.Fes angepasst WARNING werden jetzt auch den OKs hinzugezaehlt
    --  ' Sum(CASE WHEN (['+ @ProcStateCol + '] like ''D%'' AND [ProcessResultCode] = ''0'' AND [ProcessResultHasWarning]<>1)  THEN 1 ELSE 0 END) As [PResOk],' +     -- 'Done:OK'
    ' Sum(CASE WHEN (['+ @ProcStateCol + '] like ''D%'' AND [Row_isLastRes]=1 AND [ProcessResultCode] = ''0'') THEN 1 ELSE 0 END)                                   As [PResOk],' +     -- 'Done:OK'
    ' Sum(CASE WHEN (['+ @ProcStateCol + '] like ''D%'' AND [Row_isLastRes]=1 AND [ProcessResultCode] not in (''0'',''640010'')) THEN 1 ELSE 0 END)                 As [PResErr],' +    -- 'Done:Err'
    ' Sum(CASE WHEN (['+ @ProcStateCol + '] like ''D%'' AND [Row_isLastRes]=1 AND [ProcessResultCode] = ''0'' AND [ProcessResultHasWarning]=1)   THEN 1 ELSE 0 END) As [PResHasW], ' +   -- 'Done:ProcessResultHasWarning'
    ' Sum(CASE WHEN (['+ @ProcStateCol + '] like ''D%'' AND [Row_isLastRes]=1 AND [ProcessResultCode] in (''640010'')) THEN 1 ELSE 0 END)                           As [PResDonNoWriteAccess] ' + -- 'Done:Err:No write access'
    ' into ' + @TempTblName + -- einfgen in temp Tabelle!!
    ' from [dbo].[DS_AndProcessDataForCount_UDF](''' + @ProcStateCol + ''')' +
    ' WHERE ([Row_isLastRes]=1 or [Row_isLastRes] is null)'

  if CharIndex('%', @ObjectFromSiteID)>0
   begin
    if @ObjectFromSiteID <> '%'
     -- 05.03.2011 eingefuegt um bei % unnoetigen select like zu vermeiden
     begin
      -- Suche ber [ObjectFromSiteID] mit Like Operator @ObjectFromSiteID mit Like Operator erforderlich
      set @ExecuteSQLstr = @ExecuteSQLstr +
                           ' and ([ObjectFromSiteID] like ' + '''' + @ObjectFromSiteID + '''' + ')'
     end
   end
   else
   begin
    if @ObjectFromSiteID <> ''
     -- 05.03.2011 eingefuegt um bei '' unnoetigen select like zu vermeiden
     begin
      set @ExecuteSQLstr = @ExecuteSQLstr +
                          ' and ([ObjectFromSiteID] = ' + '''' + @ObjectFromSiteID + '''' + ')'
     end
   end

   /* festellung group by hat keine messbaren auswirkungen auf performance */
   set @ExecuteSQLstr = @ExecuteSQLstr +
                       ' GROUP BY ' +
                       ' [ObjectFromSiteID] '

  if @GroupDataDo = 1
  begin
   set @ExecuteSQLstr = @ExecuteSQLstr + ',' +
                       ' CASE [ObjectFromSiteID] ' +
                           '  WHEN [ObjectOwningSiteID] ' +
                           '    THEN ''1-SO (SiteObj)'' ' +
                           '  ELSE   ''2-RO (ReplObj)'' ' +
                           '  END , ' +
                       '  CASE [ObjectUgMaster_Type] ' +
                           '  WHEN ''SP'' ' +
                           '     THEN ''1-SP (Single Parts)'' ' +
                           '     ELSE ''2-AP (Assembly)'' ' +
                           '  END , ' +
                           '  ObjectType '
  end
  ------------ ## Debug -----------------------
  if @DebugPrintOn = 1
  begin
   set @ExecuteSQLstr = Replace(@ExecuteSQLstr,"     "," ")
   set @ExecuteSQLstr = Replace(@ExecuteSQLstr,"    "," ")
   set @ExecuteSQLstr = Replace(@ExecuteSQLstr,"   "," ")
   set @ExecuteSQLstr = Replace(@ExecuteSQLstr,"  "," ")

   -- Clear Debug Table
   EXECUTE zzzzzDebugTbl_Empty
   EXECUTE zzzzzDebugTbl_AddDataSet @MyProcName , '@ObjectFromSiteID' ,   @ObjectFromSiteID
   EXECUTE zzzzzDebugTbl_AddDataSet @MyProcName , '@ProcStateCol' ,       @ProcStateCol
   EXECUTE zzzzzDebugTbl_AddDataSet @MyProcName , '@ExecuteSQLstr' ,      @ExecuteSQLstr
  end

  execute sp_executesql @ExecuteSQLstr


  if @ViewFormat = 'Percent'
   begin
    -- Select fr die Anzeige mit % Daten
    -- 01.11.2010/J.Fes die Prozentzahlen fr Done:OK + Done:Warning + Done:Err + Done:NoWriAccess werden jetzt basierend auf den [PStatD P.Stat:D (Done)] berechnet
    set @ExecuteSQLstr = 'Select' +
     ' [SiteID],'
     if @GroupDataDo = 1
     begin
     set @ExecuteSQLstr = @ExecuteSQLstr +
     '[S.Or.Rep Object],' +
     '[O.UGMaster_Type],' +
     '[DataSet Type],'
     end
     set @ExecuteSQLstr = @ExecuteSQLstr +
     '[DsSum] As [Datasets:(sum)],' +

      '[PStatN]               As [P.Stat:N],' +
      'Str((100.00*[PStatN]/[DsSum]),6,2) + ''%'' As [P.Stat:N %] ,' +
      'cast([PStatX] as varchar)     + '' ('' + Str((100.00*[PStatX]/[DsSum]),6,2) + ''%)''     As [P.Stat:X(eXcludet)],' +

      '[PStatM]              As [P.Stat:M] ,' +
      'Str((100.00*[PStatM]/[DsSum]),6,2) + ''%'' As [P.Stat:M %] ,' +

      '[PStatP]              As [P.Stat:P] ,' +
      'Str((100.00*[PStatP]/[DsSum]),6,2) + ''%'' As [P.Stat:P %] ,' +

      '[PStatD]              As [P.Stat:D] ,' +
      'Str((100.00*[PStatD]/[DsSum]),6,2) + ''%'' As [P.Stat:D %] ,' +

      '[PResOk]              As [Done:OK] ,' +
      'Str((100.00*[PResOk]/[DsSum]),6,2) + ''%'' As [Done:OK %] ,' +

      '[PResErr]              As [Done:ERR] ,' +
      'Str((100.00*[PResErr]/[DsSum]),6,2) + ''%'' As [Done:ERR %] ,' +

      '[PResHasW]            As [Done:WRN] ,' +
      'Str((100.00*[PResHasW]/[DsSum]),6,2) + ''%'' As [Done:WRN %] ,' +

      '[PResDonNoWriteAccess]              As [Done:NoWriAcs] ,' +
      'Str((100.00*[PResDonNoWriteAccess]/[DsSum]),6,2) + ''%'' As [Done:NoWriAcs %]' +

    'from ##temp_tbl'
   end
  else
   begin
    -- Select fr die Anzeige mit count Daten
    set @ExecuteSQLstr = 'Select' +
     '[SiteID],'
     if @GroupDataDo = 1
     begin
     set @ExecuteSQLstr = @ExecuteSQLstr +
     '[S.Or.Rep Object],' +
     '[O.UGMaster_Type],' +
     '[DataSet Type],'
     end

     set @ExecuteSQLstr = @ExecuteSQLstr +
      '[DsSum]      As [Datasets:(sum)],' +
      '[PStatN]     As [P.Stat:N (Not.Proc)],' +
      '[PStatX]     As [P.Stat:X (eXcludet)],' +
      '[PStatM]     As [P.Stat:M (Manuell)],' +
      '[PStatP]     As [P.Stat:P (in.Proc)],' +
      '[PStatD]     As [P.Stat:D (Done)],' +
      '[PResOk]     As [Done:OK],' +
      '[PResErr]    As [Done:ERR],' +
      '[PResHasW]   As [Done:WRN],' +
      '[PResDonNoWriteAccess] As [Done:NoWriAccess]' +
      'from ##temp_tbl'
    end
   execute sp_executesql @ExecuteSQLstr
End
GO
--------------------------------------------------------------------------------
Print '-'
Print '-- [Report_203_ProcStatus_by_DataSets_MultiSiteYes_Percent] -------------'
GO
CREATE PROCEDURE Report_203_ProcStatus_by_DataSets_MultiSiteYes_Percent
       (
        @ObjectFromSiteID nvarchar(32) ,
        @ProcStateCol nvarchar(14)
       )
AS
begin
 Print '-'
 Execute Rrt_200_ProcStatus_by_DataSets_MultiSiteYes @ObjectFromSiteID, @ProcStateCol, 'Percent', 1
end
GO
--------------------------------------------------------------------------------
Print '-'
Print '-- [Report_203_ProcStatus_by_DataSets_MultiSiteYes_Percent_TypeGroupNo] -------------'
GO
CREATE PROCEDURE Report_203_ProcStatus_by_DataSets_MultiSiteYes_Percent_TypeGroupNo
       (
        @ObjectFromSiteID nvarchar(32) ,
        @ProcStateCol nvarchar(14)
       )
AS
begin
 Print '-'
 Execute Rrt_200_ProcStatus_by_DataSets_MultiSiteYes @ObjectFromSiteID, @ProcStateCol, 'Percent', 0
end
GO
--------------------------------------------------------------------------------
Print '-'
Print '-- [Report_204_ProcStatus_by_DataSets_MultiSiteYes_Count] ---------------'
GO
CREATE PROCEDURE Report_204_ProcStatus_by_DataSets_MultiSiteYes_Count
       (
        @ObjectFromSiteID nvarchar(32) ,
        @ProcStateCol nvarchar(14)
       )
AS
begin
 Print '-'
 Execute Rrt_200_ProcStatus_by_DataSets_MultiSiteYes @ObjectFromSiteID, @ProcStateCol, 'Count', 1
end
GO
--------------------------------------------------------------------------------
Print '-'
Print '-- [Report_204_ProcStatus_by_DataSets_MultiSiteYes_Count_TypeGroupNo] ---------------'
GO
CREATE PROCEDURE Report_204_ProcStatus_by_DataSets_MultiSiteYes_Count_TypeGroupNo
       (
        @ObjectFromSiteID nvarchar(32) ,
        @ProcStateCol nvarchar(14)
       )
AS
begin
 Print '-'
 Execute Rrt_200_ProcStatus_by_DataSets_MultiSiteYes @ObjectFromSiteID, @ProcStateCol, 'Count', 0
end
GO
--------------------------------------------------------------------------------
--------------------------------------------------------------------------------
--------------------------------------------------------------------------------

Print '-'
Print '-- [Rrt_200_ProcStatus_by_DataSets_MultiSiteNo] -------------------------------------'
If Exists (select Name
           from sysobjects
           where Name = "Rrt_200_ProcStatus_by_DataSets_MultiSiteNo" and type = "P")
Drop Procedure Rrt_200_ProcStatus_by_DataSets_MultiSiteNo
GO


CREATE PROCEDURE Rrt_200_ProcStatus_by_DataSets_MultiSiteNo
       (
        @ObjectFromSiteID nvarchar(32),
        @ProcStateCol nvarchar(14),
        @ViewFormat nvarchar(14), -- Valid Values "CountPercent" 'Count'
        @GroupDataDo bit  -- 29.09.2012 New J.Fes
       )
AS
begin
  DECLARE @DebugPrintOn bit
  set @DebugPrintOn = 1

  DECLARE @MyProcName nvarchar(32)
  set @MyProcName='Rrt_200_ProcStatus_by_DataSets_MultiSiteNo'

  DECLARE @ExecuteSQLstr nvarchar(max)
  DECLARE @TempTblName   nvarchar(32)

  set @TempTblName = 'tempdb..##temp_tbl_Rrt200'
  --  + '_' + @MyProcName
  IF (OBJECT_ID (@TempTblName, N'U') IS NOT NULL) exec ('drop table ' + @TempTblName)

  set @ExecuteSQLstr = 'SELECT '  +
      ' CASE [ObjectUgMaster_Type] ' +
         '  WHEN ''SP'' ' +
         '     THEN ''1-SP (Single Parts)'' ' +
         '     ELSE ''2-AP (Assembly)'' '  +
         '  END                  As [O.UGMaster_Type],'
  if @GroupDataDo = 1
   begin
    set @ExecuteSQLstr = @ExecuteSQLstr +
      ' ObjectType               As [DataSet Type], '
   end

  set @ExecuteSQLstr = @ExecuteSQLstr +

    ' COUNT(ObjectType)        AS [DsSum], ' +        -- 'Datasets (sum)'
    ' Sum(CASE WHEN ([ObjectUgMaster_FsHitCount] > 0)  THEN 1 ELSE 0 END)   As [DsSum_FsHc],' +     -- 'Datasets (sum) with hit.counts'
    ' Sum(CASE WHEN (['+ @ProcStateCol + '] like ''X%'')  THEN 1 ELSE 0 END)                                                 As [PStatX],' +     -- 'P.Stat:X (eXcludet)'
    ' Sum(CASE WHEN (['+ @ProcStateCol + '] like ''X%'' AND [ObjectUgMaster_FsHitCount] > 0)  THEN 1 ELSE 0 END)             As [PStatX_FsHc],' + -- 'P.Stat:X (eXcludet)'
    ' Sum(CASE WHEN (['+ @ProcStateCol + '] like ''M%'')  THEN 1 ELSE 0 END)                                                 As [PStatM],' +     -- 'P.Stat:M (Manuell)'
    ' Sum(CASE WHEN (['+ @ProcStateCol + '] like ''M%'' AND [ObjectUgMaster_FsHitCount] > 0)  THEN 1 ELSE 0 END)             As [PStatM_FsHc],' +     -- 'P.Stat:M (Manuell)'
    ' Sum(CASE WHEN (['+ @ProcStateCol + '] like ''N%'')  THEN 1 ELSE 0 END)                                                 As [PStatN],' +     -- 'P.Stat:N (not.Proc)'
    ' Sum(CASE WHEN (['+ @ProcStateCol + '] like ''N%'' AND [ObjectUgMaster_FsHitCount] > 0)  THEN 1 ELSE 0 END)             As [PStatN_FsHc],' +     -- 'P.Stat:N (not.Proc)'

    ' Sum(CASE WHEN (['+ @ProcStateCol + '] like ''P%'')  THEN 1 ELSE 0 END)                                                 As [PStatP],' +          -- 'P.Stat:P (in.Proc)'
    ' Sum(CASE WHEN (['+ @ProcStateCol + '] like ''P%'' AND [ObjectUgMaster_FsHitCount] > 0)  THEN 1 ELSE 0 END)             As [PStatP_FsHc],' +     -- 'P.Stat:P (in.Proc)'
    ' Sum(CASE WHEN (['+ @ProcStateCol + '] like ''D%'' AND [Row_isLastRes]=1 AND [ProcessResultCode] <> '''') THEN 1 ELSE 0 END)                                                                     As [PStatD],' +          -- 'P.Stat:D (Done)'
    ' Sum(CASE WHEN (['+ @ProcStateCol + '] like ''D%'' AND [Row_isLastRes]=1 AND [ProcessResultCode] <> '''' AND [ObjectUgMaster_FsHitCount] > 0)  THEN 1 ELSE 0 END)                                As [PStatD_FsHc],' +     -- 'P.Stat:D (Done)'

    -- 26.09.2012 J.Fes angepasst WARNING werden jetzt auch den OKs hinzugezaehlt
    -- ' Sum(CASE WHEN (['+ @ProcStateCol + '] like ''D%'' AND [ProcessResultCode] = ''0'' AND [ProcessResultHasWarning]<>1)   THEN 1 ELSE 0 END) As [PResOk],' +       -- 'Done:OK'
    ' Sum(CASE WHEN (['+ @ProcStateCol + '] like ''D%'' AND [Row_isLastRes]=1 AND [ProcessResultCode] = ''0'' )                                   THEN 1 ELSE 0 END)                                  As [PResOk],' +       -- 'Done:OK'

    ' Sum(CASE WHEN (['+ @ProcStateCol + '] like ''D%'' AND [Row_isLastRes]=1 AND [ProcessResultCode] = ''0'' AND [ObjectUgMaster_FsHitCount]>0)  THEN 1 ELSE 0 END)                                  As [PResOk_FsHc],' +  -- 'Done:OK'

    ' Sum(CASE WHEN (['+ @ProcStateCol + '] like ''D%'' AND [Row_isLastRes]=1 AND [ProcessResultCode] = ''0'' AND [ProcessResultHasWarning]=1)    THEN 1 ELSE 0 END)                                  As [PResHasW], ' +        -- 'Done:ProcessResultHasWarning'
    ' Sum(CASE WHEN (['+ @ProcStateCol + '] like ''D%'' AND [Row_isLastRes]=1 AND [ProcessResultCode] = ''0'' AND [ProcessResultHasWarning]=1 AND [ObjectUgMaster_FsHitCount] > 0) THEN 1 ELSE 0 END) As [PResHasW_FsHc], ' +   -- 'Done:ProcessResultHasWarning'

    ' Sum(CASE WHEN (['+ @ProcStateCol + '] like ''D%'' AND [Row_isLastRes]=1 AND [ProcessResultCode] not in (''0'',''640010'')) THEN 1 ELSE 0 END)                                                   As [PResErr],' +    -- 'Done:Err'
    ' Sum(CASE WHEN (['+ @ProcStateCol + '] like ''D%'' AND [Row_isLastRes]=1 AND [ProcessResultCode] not in (''0'',''640010'') AND [ObjectUgMaster_FsHitCount] > 0) THEN 1 ELSE 0 END)               As [PResErr_FsHc],' +    -- 'Done:Err'

    ' Sum(CASE WHEN (['+ @ProcStateCol + '] like ''D%'' AND [Row_isLastRes]=1 AND [ProcessResultCode] in (''640010'')) THEN 1 ELSE 0 END)                                                   As [PResDonNoWriteAccess] ' + -- 'Done:Err:No write access'


    ' into ' + @TempTblName + -- einfgen in temp Tabelle!!
    ' from [dbo].[DS_AndProcessDataForCount_UDF](''' + @ProcStateCol + ''')' +
    ' WHERE ([Row_isLastRes]=1 or [Row_isLastRes] is null)'

  if CharIndex('%', @ObjectFromSiteID)>0
   begin
    if @ObjectFromSiteID <> '%'
     -- 05.03.2011 eingefuegt um bei % unnoetigen select like zu vermeiden
     begin
      -- Suche ber [ObjectFromSiteID] mit Like Operator @ObjectFromSiteID mit Like Operator erforderlich
      set @ExecuteSQLstr = @ExecuteSQLstr +
                           ' and ([ObjectFromSiteID] like ' + '''' + @ObjectFromSiteID + '''' + ')'
     end
   end
   else
   begin
    if @ObjectFromSiteID <> ''
     -- 05.03.2011 eingefuegt um bei '' unnoetigen select like zu vermeiden
     begin
      set @ExecuteSQLstr = @ExecuteSQLstr +
                          ' and ([ObjectFromSiteID] = ' + '''' + @ObjectFromSiteID + '''' + ')'
     end
   end

   set @ExecuteSQLstr = @ExecuteSQLstr +
                    ' GROUP BY ' +
                    '  CASE [ObjectUgMaster_Type] ' +
                        '  WHEN ''SP'' ' +
                        '     THEN ''1-SP (Single Parts)'' ' +
                        '     ELSE ''2-AP (Assembly)'' ' +
                        '  END '

  if @GroupDataDo = 1
  begin
   /* festellung group by hat keine messbaren auswirkungen auf performance */
   set @ExecuteSQLstr = @ExecuteSQLstr +
                           ', ObjectType '
   end
  ------------ ## Debug -----------------------
  if @DebugPrintOn = 1
  begin
   set @ExecuteSQLstr = Replace(@ExecuteSQLstr,"     "," ")
   set @ExecuteSQLstr = Replace(@ExecuteSQLstr,"    "," ")
   set @ExecuteSQLstr = Replace(@ExecuteSQLstr,"   "," ")
   set @ExecuteSQLstr = Replace(@ExecuteSQLstr,"  "," ")

   -- Clear Debug Table
   EXECUTE zzzzzDebugTbl_Empty
   EXECUTE zzzzzDebugTbl_AddDataSet @MyProcName , '@ObjectFromSiteID' ,   @ObjectFromSiteID
   EXECUTE zzzzzDebugTbl_AddDataSet @MyProcName , '@ProcStateCol' ,       @ProcStateCol
   EXECUTE zzzzzDebugTbl_AddDataSet @MyProcName , '@ExecuteSQLstr' ,      @ExecuteSQLstr
  end
  execute sp_executesql @ExecuteSQLstr


  if @ViewFormat = 'Percent'
   begin
    -- Select fr die Anzeige mit % Daten
    -- 01.11.2010/J.Fes die Prozentzahlen fr Done:OK + Done:Warning + Done:Err + Done:NoWriAccess werden jetzt basierend auf den [PStatD P.Stat:D (Done)] berechnet
    set @ExecuteSQLstr = 'Select' +
     ' [O.UGMaster_Type],'

    if @GroupDataDo = 1
     begin
      set @ExecuteSQLstr = @ExecuteSQLstr +
       ' [DataSet Type],'
     end

     set @ExecuteSQLstr = @ExecuteSQLstr +
     ' [DsSum] As [Datasets:(sum)],' +
     ' [PStatN] As [P:N Count],' +
     '                                        Str((100.00*[PStatN]/[DsSum]),6,2) + ''%''        As [P:N %],' +
     ' cast([PStatX] as varchar)     + '' ('' + Str((100.00*[PStatX]/[DsSum]),6,2) + ''%)''     As [P.Stat:X (eXcludet)],' +
     ' cast([PStatM] as varchar)     + '' ('' + Str((100.00*[PStatM]/[DsSum]),6,2) + ''%)''     As [P.Stat:M (Manuell)],' +
     ' cast([PStatP] as varchar)     + '' ('' + Str((100.00*[PStatP]/[DsSum]),6,2) + ''%)''     As [P.Stat:P (in.Proc)],' +
     ' cast([PStatD] as varchar)     + '' ('' + Str((100.00*[PStatD]/[DsSum]),6,2) + ''%)''     As [P.Stat:D (Done)],' +
     ' cast([PResOk] as varchar)     + '' ('' + Str((100.00*[PResOk]/[DsSum]),6,2) + ''%)''     As [Done:OK],' +
     ' cast([PResErr] as varchar)    + '' ('' + Str((100.00*[PResErr]/[DsSum]),6,2) + ''%)''    As [Done:ERR],' +
     ' cast([PResHasW] as varchar)   + '' ('' + Str((100.00*[PResHasW]/[DsSum]),6,2) + ''%)''   As [Done:WRN],' +
     ' cast([PResDonNoWriteAccess] as varchar) + '' ('' + Str((100.0*[PResDonNoWriteAccess]/[DsSum]),6,2) + ''%)'' As [Done:NoWriAccess]' +
     ' from ##temp_tbl_Rrt200'
   end
  else
   begin
    -- Select fr die Anzeige mit count Daten
    set @ExecuteSQLstr = 'Select' +
      ' [O.UGMaster_Type],'

    if @GroupDataDo = 1
     begin
      set @ExecuteSQLstr = @ExecuteSQLstr +
      ' [DataSet Type],'
     end

     set @ExecuteSQLstr = @ExecuteSQLstr +
      ' [DsSum]                As [Datasets:(sum)],' +
      ' [DsSum_FsHc]           As [Datasets.FsHc:(sum)],' +
      ' [PStatN]               As [P:N (Not.Proc)],' +
      ' [PStatN_FsHc]          As [P:N.FsHc (Not.Proc)],' +
      ' [PStatX]               As [P:X (eXcludet)],' +
      ' [PStatX_FsHc]          As [P:X.FsHc (eXcludet)],' +
      ' [PStatM]               As [P:M (Manuell)],' +
      ' [PStatM_FsHc]          As [P:M.FsHc (Manuell)],' +
      ' [PStatP]               As [P:P (in.Proc)],' +
      ' [PStatP_FsHc]          As [P:P.FsHc(in.Proc)],' +
      ' [PStatD]               As [D (Done sum)],' +
      ' [PStatD_FsHc]          As [D.FsHc (Done sum)],' +
      ' [PResOk]               As [D:OK],' +
      ' [PResOk_FsHc]          As [D:OK.FsHc],' +
      ' [PResHasW]             As [D:WRN],' +
      ' [PResHasW_FsHc]        As [D:WRN.FsHc],' +
      ' [PResErr]              As [D:ERR],' +
      ' [PResErr_FsHc]         As [D:ERR.FsHc],' +
      ' [PResDonNoWriteAccess] As [D:NoWriAccess]' +
      ' from ##temp_tbl_Rrt200'
    end
    execute sp_executesql @ExecuteSQLstr

End
GO

--------------------------------------------------------------------------------
Print '-'
Print '-- [Report_201_ProcStatus_by_DataSets_MultiSiteNo_Count] ----------------------------'
GO
CREATE PROCEDURE Report_201_ProcStatus_by_DataSets_MultiSiteNo_Count
       (
        @ObjectFromSiteID nvarchar(32) ,
        @ProcStateCol nvarchar(14)
       )
AS
begin
 Print '-'
 Execute Rrt_200_ProcStatus_by_DataSets_MultiSiteNo @ObjectFromSiteID, @ProcStateCol, 'Count', 1
end
GO

--------------------------------------------------------------------------------
Print '-'
Print '-- [Report_202_ProcStatus_by_DataSets_MultiSiteNo_Percent] --------------------------'
GO
CREATE PROCEDURE Report_202_ProcStatus_by_DataSets_MultiSiteNo_Percent
       (
        @ObjectFromSiteID nvarchar(32) ,
        @ProcStateCol nvarchar(14)
       )
AS
begin
 Print '-'
 Execute Rrt_200_ProcStatus_by_DataSets_MultiSiteNo @ObjectFromSiteID, @ProcStateCol, 'Percent', 1
end
GO

Print '-'
Print '-- [Report_201_ProcStatus_by_DataSets_MultiSiteNo_Count_TypeGroupNo] ----------------------------'
-- new 29.09.2012
GO
CREATE PROCEDURE Report_201_ProcStatus_by_DataSets_MultiSiteNo_Count_TypeGroupNo
       (
        @ObjectFromSiteID nvarchar(32) ,
        @ProcStateCol nvarchar(14)
       )
AS
begin
 Print '-'
 Execute Rrt_200_ProcStatus_by_DataSets_MultiSiteNo @ObjectFromSiteID, @ProcStateCol, 'Count', 0
end
GO

--------------------------------------------------------------------------------
Print '-'
Print '-- [Report_202_ProcStatus_by_DataSets_MultiSiteNo_Percent_TypeGroupNo] --------------------------'
GO
CREATE PROCEDURE Report_202_ProcStatus_by_DataSets_MultiSiteNo_Percent_TypeGroupNo
       (
        @ObjectFromSiteID nvarchar(32) ,
        @ProcStateCol nvarchar(14)
       )
AS
begin
 Print '-'
 Execute Rrt_200_ProcStatus_by_DataSets_MultiSiteNo @ObjectFromSiteID, @ProcStateCol, 'Percent', 0
end
GO
--------------------------------------------------------------------------------
--------------------------------------------------------------------------------
Print '-'
Print '-- [Report_301_List_of_all_Datasets_With_Errors] ----------------------------------------'
GO
CREATE PROCEDURE Report_301_List_of_all_Datasets_With_Errors
       (
        @ObjectFromSiteID nvarchar(32) ,
        @ProcStateCol nvarchar(14)
       )

-- Hinweis:
-- 25.04.2012 J.Fes dieser Report darf nur in Abstimmung mit den zugehrigen L&L Formularen angepasst werden.
--            |-> siehe ..\01-BinServer\Resources\ReportLayouts\Report_902_ProcessStatistic_And_ProcessResults_MultiSiteYes

AS
begin
  DECLARE @DebugPrintOn bit
  set @DebugPrintOn = 1
  DECLARE @MyProcName nvarchar(32)
  set @MyProcName='Report_301_List_of_all_Datasets_With_Errors'
  DECLARE @ExecuteSQLstr nvarchar(max)
  DECLARE @TempTblName   nvarchar(32)
--   set @TempTblName = '##temp_tbl'
--   IF (OBJECT_ID ('tempdb..' + @TempTblName, N'U') IS NOT NULL) exec ('drop table ' + @TempTblName)
  set @TempTblName = 'tempdb..##temp_tbl'
  IF (OBJECT_ID (@TempTblName, N'U') IS NOT NULL) exec ('drop table ' + @TempTblName)

  -- 25.04.2012 08:25 New Columes: ObjectOwningSiteID,ObjectGroup,ObjectLastModUser,ObjectLastModDate,ObjectReleaseState,ObjectReleaseDate
  -- S.Or.Rep Object --> 0.SiteOwing.SorR
  -- List_Of_All_Datasets_With_Errors.S_Or_Rep Object -> List_Of_All_Datasets_With_Errors.0_SiteOwing_SorR
  set @ExecuteSQLstr =  'SELECT ' +
                        ' [ObjectFromSiteID] As [O.SiteID],' +

                        ' CASE [ObjectFromSiteID] ' +
                           ' WHEN [ObjectOwningSiteID] ' +
                           '   THEN ''1-SO (SiteObj)'' ' +
                           ' ELSE   ''2-RO (ReplObj)'' ' +
                           ' END                 AS [S.Or.Rep Object],' +

                        ' CASE [ObjectUgMaster_Type] ' +
                           ' WHEN ''SP'' ' +
                           '    THEN ''1-SP (Single Parts)'' ' +
                           '    ELSE ''2-AP (Assembly)'' '  +
                           ' END                 AS [O.UGMaster_Type],' +

                           ' [IrName]            AS [O.IR.ID],' +
                           ' [ObjectName]        AS [O.Name],' +
                           ' [ObjectType]        AS [O.Type],' +
                           ' [ObjectUgMaster_APLevels] As [O.AP.LevN],' +
                           ' [ObjectUgMaster_CompCount] As [O.AP.CompN],' +

                           ' [ObjectOwningSiteID] As [O.OwningSiteID],' +
                           ' [ObjectOwner] As [O.Owner],' +
                           ' [ObjectGroup] As [O.Group],' +
                           ' [ObjectLastModUser] As [O.LastModUser],' +
                           ' [ObjectLastModDate] As [O.LastModDate],' +
                           ' [ObjectReleaseState] As [O.ReleaseState],' +
                           ' [ObjectReleaseDate] As [O.ReleaseDate],' +

                           -- #New: 27.09.2012 J.Fes  + @ProcStateCol +
                           ' [' + @ProcStateCol + '] AS [P.State],' +
                           ' [ProcessResultCode] AS [P.Result.Code],' +
                           ' [ProcessResultMsg]  AS [P.Result.Message],' +
                           -- #New: 27.09.2012 J.Fes  + ProcessResultLink
                           ' [ProcessResultLink]  AS [P.Result.Link],' +
                           -- #New: 27.09.2012 J.Fes  +  ProcessResultHasWarning
                           ' [ProcessResultHasWarning]  AS [P.Result.WRN]' +

                           ' from [dbo].[DS_AndProcessData_UDF]('  + '''' + @ProcStateCol + '''' + ')' +
--                            ' WHERE  ([Row_isLastRes]=1 or [Row_isLastRes] is null) and' +
                           ' WHERE  ([Row_isLastRes]=1) and' +
                           '        ([' + @ProcStateCol + '] like ''D%'') and (ProcessResultCode <> ''0'') and (ProcessResultCode <>' + '''' + '''' + ')'
  -- 03.04.2012 15:28 J.Fes angepasst
  if CharIndex('%', @ObjectFromSiteID)>0
   begin
    if @ObjectFromSiteID <> '%'
     -- 05.03.2011 eingefuegt um bei % unnoetigen select like zu vermeiden
     begin
      -- Suche ber [ObjectFromSiteID] mit Like Operator @ObjectFromSiteID mit Like Operator erforderlich
      set @ExecuteSQLstr = @ExecuteSQLstr +
                           ' and ([ObjectFromSiteID]=' + '''' + @ObjectFromSiteID + '''' + ')'
     end
   end
   else
   begin
    if @ObjectFromSiteID <> ''
     -- 05.03.2011 eingefuegt um bei '' unnoetigen select like zu vermeiden
     begin
      set @ExecuteSQLstr = @ExecuteSQLstr +
                          ' and ([ObjectFromSiteID] = ' + '''' + @ObjectFromSiteID + '''' + ')'
     end
   end

  if @DebugPrintOn = 1
  begin

   set @ExecuteSQLstr = Replace(@ExecuteSQLstr,"     "," ")
   set @ExecuteSQLstr = Replace(@ExecuteSQLstr,"    "," ")
   set @ExecuteSQLstr = Replace(@ExecuteSQLstr,"   "," ")
   set @ExecuteSQLstr = Replace(@ExecuteSQLstr,"  "," ")

   -- Clear Debug Table
   EXECUTE zzzzzDebugTbl_Empty
   EXECUTE zzzzzDebugTbl_AddDataSet @MyProcName , '@ObjectFromSiteID' ,  @ObjectFromSiteID
   EXECUTE zzzzzDebugTbl_AddDataSet @MyProcName , '@ProcStateCol' ,      @ProcStateCol
   EXECUTE zzzzzDebugTbl_AddDataSet @MyProcName , '@ExecuteSQLstr' ,     @ExecuteSQLstr
  end
 execute sp_executesql @ExecuteSQLstr
end
go
--------------------------------------------------------------------------------
--------------------------------------------------------------------------------
--------------------------------------------------------------------------------
-- neu erstellt 02.03.2010 23:58

Print '-'
Print '-- [Report_302_List_of_all_Datasets_With_Warnings] ----------------------------------------'
GO
CREATE PROCEDURE Report_302_List_of_all_Datasets_With_Warnings
       (
        @ObjectFromSiteID nvarchar(32) ,
        @ProcStateCol nvarchar(14)
       )

AS
begin
  DECLARE @DebugPrintOn bit
  set @DebugPrintOn = 1
  DECLARE @MyProcName nvarchar(32)
  set @MyProcName='Report_302_List_of_all_Datasets_With_Warnings'
  DECLARE @ExecuteSQLstr nvarchar(max)
  DECLARE @TempTblName   nvarchar(32)
--   set @TempTblName = '##temp_tbl'
--   IF (OBJECT_ID ('tempdb..' + @TempTblName, N'U') IS NOT NULL) exec ('drop table ' + @TempTblName)
  set @TempTblName = 'tempdb..##temp_tbl'
  IF (OBJECT_ID (@TempTblName, N'U') IS NOT NULL) exec ('drop table ' + @TempTblName)


  set @ExecuteSQLstr =  'SELECT [ObjectFromSiteID] As [SiteID] ,' +

                        ' CASE [ObjectFromSiteID] ' +
                           ' WHEN [ObjectOwningSiteID] ' +
                           '   THEN ''1-SO (SiteObj)'' ' +
                           ' ELSE   ''2-RO (ReplObj)'' ' +
                           ' END                 AS [S.Or.Rep.Object], ' +

                        ' CASE [ObjectUgMaster_Type] ' +
                           ' WHEN ''SP'' ' +
                           '    THEN ''1-SP (Single Parts)'' ' +
                           '    ELSE ''2-AP (Assembly)'' '  +
                           ' END                 AS [O.UGMaster_Type],' +

                           ' [IrName]            AS [IR.Id],' +
                           ' [ObjectName]        AS [O.Name],' +
                           ' [ObjectType]        AS [O.Type],' +
                           ' [ProcessResultCode] AS [P.Result.Code],' +
                           ' [ProcessResultMsg]  AS [P.Result.Message],' +
                           ' [ProcessResultHasWarning] AS [P.Result.HasWarning],' +
                           ' [ProcessResultLink] AS [Link to Result]' +
                           ' from [dbo].[DS_AndProcessData_UDF]('  + '''' + @ProcStateCol + '''' + ')' +

                           ' WHERE  ([Row_isLastRes]=1 or [Row_isLastRes] is null) and' +
                           '        (' + @ProcStateCol + ' like ''D%'') and ([ProcessResultHasWarning]=''1'') -- and (ProcessResultCode <>' + '''' + '''' + ')'
  --                                                       |-> 23.08.2012 15:44 J.Fes @ProcStateCol + 'like ''D*''  engetragen
  if CharIndex('%', @ObjectFromSiteID)>0
   begin
    if @ObjectFromSiteID <> '%'
     -- 05.03.2011 eingefuegt um bei % unnoetigen select like zu vermeiden
     begin
      -- Suche ber [ObjectFromSiteID] mit Like Operator @ObjectFromSiteID mit Like Operator erforderlich
      set @ExecuteSQLstr = @ExecuteSQLstr +
                           ' and ([ObjectFromSiteID] like ' + '''' + @ObjectFromSiteID + '''' + ')'
     end
   end
   else
   begin
    if @ObjectFromSiteID <> ''
     -- 05.03.2011 eingefuegt um bei '' unnoetigen select like zu vermeiden
     begin
      set @ExecuteSQLstr = @ExecuteSQLstr +
                          ' and ([ObjectFromSiteID] = ' + '''' + @ObjectFromSiteID + '''' + ')'
     end
   end

  if @DebugPrintOn = 1
  begin
   set @ExecuteSQLstr = Replace(@ExecuteSQLstr,"     "," ")
   set @ExecuteSQLstr = Replace(@ExecuteSQLstr,"    "," ")
   set @ExecuteSQLstr = Replace(@ExecuteSQLstr,"   "," ")
   set @ExecuteSQLstr = Replace(@ExecuteSQLstr,"  "," ")

   -- Clear Debug Table
   EXECUTE zzzzzDebugTbl_Empty
   EXECUTE zzzzzDebugTbl_AddDataSet @MyProcName , '@ObjectFromSiteID' ,  @ObjectFromSiteID
   EXECUTE zzzzzDebugTbl_AddDataSet @MyProcName , '@ProcStateCol' ,      @ProcStateCol
   EXECUTE zzzzzDebugTbl_AddDataSet @MyProcName , '@ExecuteSQLstr' ,     @ExecuteSQLstr
  end
 execute sp_executesql @ExecuteSQLstr
end
go


-- neu erstellt 02.03.2010 23:58

Print '-'
Print '-- [Report_102_VolumeStatistic] ----------------------------------------'
GO
CREATE PROCEDURE Report_102_VolumeStatistic
       (
        @ObjectFromSiteID nvarchar(32) ,
        @ProcStateCol nvarchar(14)
       )

AS
begin
  DECLARE @DebugPrintOn bit
  set @DebugPrintOn = 1
  DECLARE @MyProcName nvarchar(32)
  set @MyProcName='Report_102_VolumeStatistic'
  DECLARE @ExecuteSQLstr nvarchar(max)
  DECLARE @TempTblName   nvarchar(32)
--   set @TempTblName = '##temp_tbl'
--   IF (OBJECT_ID ('tempdb..' + @TempTblName, N'U') IS NOT NULL) exec ('drop table ' + @TempTblName)
--   set @TempTblName = 'tempdb..##temp_tbl'
--   IF (OBJECT_ID (@TempTblName, N'U') IS NOT NULL) exec ('drop table ' + @TempTblName)

  set @ExecuteSQLstr = +
        'SELECT ' +
        '  dbo.Objects_tbl.ObjectFromSiteID As [SiteId], ' +
        '  dbo.Objects_tbl.ObjectFs_Vol As [Volume.Name], ' +
        '  COUNT(dbo.Objects_tbl.ObjectFs_Vol) AS [has n (latest Part.Files) on Volume] ' +
        'FROM ' +
        '  dbo.Objects_tbl ' +
        'WHERE' +
        '  Objects_tbl.ObjectClass = ''DS'''


  if CharIndex('%', @ObjectFromSiteID)>0
   begin
    if @ObjectFromSiteID <> '%'
     -- 05.03.2011 eingefuegt um bei % unnoetigen select like zu vermeiden
     begin
      -- Suche ber [ObjectFromSiteID] mit Like Operator @ObjectFromSiteID mit Like Operator erforderlich
      set @ExecuteSQLstr = @ExecuteSQLstr +
                           ' and ([ObjectFromSiteID] like ' + '''' + @ObjectFromSiteID + '''' + ') '
     end
   end
   else
   begin
    if @ObjectFromSiteID <> ''
     -- 05.03.2011 eingefuegt um bei '' unnoetigen select like zu vermeiden
     begin
      set @ExecuteSQLstr = @ExecuteSQLstr +
                          ' and ([ObjectFromSiteID] = ' + '''' + @ObjectFromSiteID + '''' + ') '
     end
   end

   set @ExecuteSQLstr = @ExecuteSQLstr +
  'GROUP BY' +
  ' dbo.Objects_tbl.ObjectFs_Vol, ' +
  ' dbo.Objects_tbl.ObjectFromSiteID ' +
  'Order By' +
  ' dbo.Objects_tbl.ObjectFromSiteID, ' +
  ' dbo.Objects_tbl.ObjectFs_Vol '


  if @DebugPrintOn = 1
  begin
   set @ExecuteSQLstr = Replace(@ExecuteSQLstr,"     "," ")
   set @ExecuteSQLstr = Replace(@ExecuteSQLstr,"    "," ")
   set @ExecuteSQLstr = Replace(@ExecuteSQLstr,"   "," ")
   set @ExecuteSQLstr = Replace(@ExecuteSQLstr,"  "," ")

   -- Clear Debug Table
   EXECUTE zzzzzDebugTbl_Empty
   EXECUTE zzzzzDebugTbl_AddDataSet @MyProcName , '@ObjectFromSiteID' ,  @ObjectFromSiteID
   EXECUTE zzzzzDebugTbl_AddDataSet @MyProcName , '@ProcStateCol' ,      @ProcStateCol
   EXECUTE zzzzzDebugTbl_AddDataSet @MyProcName , '@ExecuteSQLstr' ,     @ExecuteSQLstr
  end
 execute sp_executesql @ExecuteSQLstr
end
go

--------------------------------------------------------------------------------
Print '-'
Print '-- [Report_303_List_of_all_happend_Errors] ---------------------'
GO

CREATE PROCEDURE Report_303_List_of_all_happend_Errors
       (
        @ObjectFromSiteID nvarchar(32) ,
        @ProcStateCol nvarchar(32)
       )


AS
-- new 24.04.2012 15:21 J.Fes
BEGIN
  DECLARE @DebugPrintOn bit
  set @DebugPrintOn = 1
  DECLARE @MyProcName nvarchar(32)
  set @MyProcName='Report_303_List_of_all_happend_Errors'
  DECLARE @ExecuteSQLstr nvarchar(max)
  DECLARE @TempTblName   nvarchar(32)

  set @TempTblName = 'tempdb..##temp_tbl'
  IF (OBJECT_ID (@TempTblName, N'U') IS NOT NULL) exec ('drop table ' + @TempTblName)

  set @ExecuteSQLstr =  'SELECT DISTINCT' +
                           ' [ObjectFromSiteID] As [SiteID],' +
                           ' [ProcessResultCode] AS [P.Result.Code],' +
                           ' [ProcessResultMsg]  AS [P.Result.Message]' +
                           ', COUNT([ProcessResultMsg]) AS [R.Error.Count]' +
                           ' from [dbo].[DS_AndProcessData_UDF]('  + '''' + @ProcStateCol + '''' + ')' +

                           ' WHERE  ([Row_isLastRes]=1 or [Row_isLastRes] is null) and' +
                           '        ([' + @ProcStateCol + '] like ''D%'') and (ProcessResultCode <> ''0'') and (ProcessResultCode <>' + '''' + '''' + ')'


  -- 03.04.2012 15:28 J.Fes angepasst
  if CharIndex('%', @ObjectFromSiteID)>0
   begin
    if @ObjectFromSiteID <> '%'
     -- 05.03.2011 eingefuegt um bei % unnoetigen select like zu vermeiden
     begin
      -- Suche ber [ObjectFromSiteID] mit Like Operator @ObjectFromSiteID mit Like Operator erforderlich
      set @ExecuteSQLstr = @ExecuteSQLstr +
                           ' and ([ObjectFromSiteID] = ' + '''' + @ObjectFromSiteID + '''' + ')'
     end
   end
   else
   begin
    if @ObjectFromSiteID <> ''
     -- 05.03.2011 eingefuegt um bei '' unnoetigen select like zu vermeiden
     begin
      set @ExecuteSQLstr = @ExecuteSQLstr +
                          ' and ([ObjectFromSiteID] = ' + '''' + @ObjectFromSiteID + '''' + ')'
     end
   end

  set @ExecuteSQLstr = @ExecuteSQLstr +
                           ' GROUP BY ObjectFromSiteID,ProcessResultCode,ProcessResultMsg'



  if @DebugPrintOn = 1
  begin

   set @ExecuteSQLstr = Replace(@ExecuteSQLstr,"     "," ")
   set @ExecuteSQLstr = Replace(@ExecuteSQLstr,"    "," ")
   set @ExecuteSQLstr = Replace(@ExecuteSQLstr,"   "," ")
   set @ExecuteSQLstr = Replace(@ExecuteSQLstr,"  "," ")

   -- Clear Debug Table
   EXECUTE zzzzzDebugTbl_Empty
   EXECUTE zzzzzDebugTbl_AddDataSet @MyProcName , '@ObjectFromSiteID' ,  @ObjectFromSiteID
   EXECUTE zzzzzDebugTbl_AddDataSet @MyProcName , '@ProcStateCol' ,      @ProcStateCol
   EXECUTE zzzzzDebugTbl_AddDataSet @MyProcName , '@ExecuteSQLstr' ,     @ExecuteSQLstr
  end
 execute sp_executesql @ExecuteSQLstr
END
go
--------------------------------------------------------------------------------
Print '-'
Print '-- [Report_801_ProcessTime_perSite] -------------------------------------'
GO

CREATE PROCEDURE Report_801_ProcessTime_perSite
       (
        @ObjectFromSiteID nvarchar(32) ,
        @ProcStateCol nvarchar(32)
       )

AS
-- new 24.04.2012 15:21 J.Fes
BEGIN
   -- evtl. TempTabelle lschen
   IF OBJECT_ID('zztmp_Report_801_ProcessTime_perSite_tbl', N'U') IS NOT NULL
     begin
     Drop table zztmp_Report_801_ProcessTime_perSite_tbl
     end

   SELECT
     DS_AndProcessData_UDF.ObjectFromSiteID,
     DS_AndProcessData_UDF.ProcessPacketName,
     COUNT(DS_AndProcessData_UDF.ObjectFromSiteID)  AS Datasets_n,
     min(DS_AndProcessData_UDF.ProcessTimeStart)    As FirstJobStart,
     max(DS_AndProcessData_UDF.ProcessTimeEnd)      As LastJobFinish,
     DateDiff(ss, DS_AndProcessData_UDF.ProcessTimeStart, DS_AndProcessData_UDF.ProcessTimeEnd) AS DurationForPaket_sec
     INTO zztmp_Report_801_ProcessTime_perSite_tbl
   FROM
     DS_AndProcessData_UDF(@ProcStateCol)
   WHERE
     DS_AndProcessData_UDF.Row_isLastRes = 1 and
     DS_AndProcessData_UDF.ProcessTimeStart IS NOT NULL and
     DS_AndProcessData_UDF.ProcessTimeEnd > DS_AndProcessData_UDF.ProcessTimeStart and
     DateDiff(ss, DS_AndProcessData_UDF.ProcessTimeStart, DS_AndProcessData_UDF.ProcessTimeEnd) > 10
    -- and ObjectFromSiteID = @ObjectFromSiteID
   Group by
    -- DS_AndProcessData_UDF.ObjectCliName
    DS_AndProcessData_UDF.ObjectFromSiteID,
    DS_AndProcessData_UDF.ProcessPacketName,
    DateDiff(ss, DS_AndProcessData_UDF.ProcessTimeStart,
                 DS_AndProcessData_UDF.ProcessTimeEnd)


     -- Abfrage 2 Temp Tabelle zusammenfassen !
     -- CASE WHEN SPOwnigSite_N>0 .. erforderlich wegen Division durch "0"
   Select ObjectFromSiteID As 'Site' ,
              sum(Datasets_n) As 'DS total [parts]' ,
              sum(cast(DurationForPaket_sec As float))/3600 As 'Computer Process time total [h]',
              min(FirstJobStart) As 'First job start Date/Time',
              max(LastJobFinish) As 'Last job finish Date/Time'
          ,   (cast(DateDiff(ss, min(FirstJobStart), max(LastJobFinish)) As float) / 3600 ) As 'Timeframe between First job start and Last Job finish[h]'
      From zztmp_Report_801_ProcessTime_perSite_tbl
   GROUP BY
         ObjectFromSiteID
   ORDER BY ObjectFromSiteID
END
GO
--------------------------------------------------------------------------------
CREATE PROCEDURE dbo.Report_902_ProcessStatistic_And_ProcessResults_MultiSiteYes
       (
        @ObjectFromSiteID nvarchar(32) ,
        @ProcStateCol nvarchar(32)
       )
AS
BEGIN
  -- new 25.04.2012 20:16
  -- Step Setup Base Layout do not with numbers do not use -
  EXEC dbo.ReportPageNamesInit 'Process Results',                    'Process Statistic and Lists of results'

  EXEC dbo.ReportPageNamesAdd  'Process_Statistic',                  'Statistic:[Summary of all processed datasets]'
  EXEC dbo.ReportPageNamesAdd  'List_Of_All_Happend_Errors',         'Result:[List of all happened errors]'
  EXEC dbo.ReportPageNamesAdd  'List_Of_All_Datasets_With_Errors',   'Result:[List of all datasets with errors]'
  EXEC dbo.ReportPageNamesAdd  'List_Of_All_Datasets_With_Warnings', 'Result:[List of all datasets with warnings]'
  EXEC dbo.ReportPageNamesGet

  EXEC dbo.Report_204_ProcStatus_by_DataSets_MultiSiteYes_Count @ObjectFromSiteID, @ProcStateCol
  EXEC dbo.Report_303_List_of_all_happend_Errors                @ObjectFromSiteID, @ProcStateCol
  EXEC dbo.Report_301_List_of_all_Datasets_With_Errors          @ObjectFromSiteID, @ProcStateCol
  EXEC dbo.Report_302_List_of_all_Datasets_With_Warnings        @ObjectFromSiteID, @ProcStateCol

END
GO

--------------------------------------------------------------------------------
-- Print '-'
-- Print '-- [Report_402_PFM_without_PFMTemplate new 16.11.2010] ----------------------------------------'
-- GO
-- CREATE PROCEDURE Report_402_PFM_without_PFMTemplate
--        (
--         @ObjectFromSiteID nvarchar(32) ,
--         @ProcStateCol nvarchar(14)
--        )
--
-- AS
-- begin
--   -- selectiert alle PFM die ohne PFM Template in der DB abgelegt sind
--   DECLARE @DebugPrintOn bit
--   set @DebugPrintOn = 1
--   DECLARE @MyProcName nvarchar(32)
--   set @MyProcName='Report_402_PFM_without_PFMTemplate'
--   DECLARE @ExecuteSQLstr nvarchar(max)
--   DECLARE @TempTblName   nvarchar(32)
--   set @TempTblName = '##temp_tbl'
--
--   SELECT DISTINCT
--     dbo.Objects_tbl.ObjectName AS ItemRev,
--     dbo.Objects_tbl.ObjectFromSiteID,
--     dbo.Objects_tbl.ObjectOwningSiteID,
--     dbo.Objects_tbl.ObjectOwner,
--     dbo.Objects_tbl.ObjectGroup,
--     dbo.Objects_tbl.ObjectCreateDate,
--     dbo.Objects_tbl.ObjectLastModUser,
--     dbo.Objects_tbl.ObjectLastModDate,
--     dbo.Objects_tbl.ObjectUgMaster_PartFamMemName AS [PF.Name],
--     dbo.Objects_tbl.ObjectCliName
--   FROM
--     dbo.Objects_tbl
--   WHERE
--     dbo.Objects_tbl.ObjectFromSiteID = @ObjectFromSiteID AND
--     dbo.Objects_tbl.ObjectUgMaster_PartFamMemName NOT IN ('','~') AND
--     dbo.Objects_tbl.ObjectUgMaster_PartFamMemName +'/' NOT IN
--     (SELECT
--       SUBSTRING(dbo.Objects_tbl.ObjectName, 1, CHARINDEX('/', dbo.Objects_tbl.ObjectName)) as [PfMName]
--       FROM dbo.Objects_tbl
--       WHERE dbo.Objects_tbl.Objectclass = 'IR' and
--             dbo.Objects_tbl.ObjectFromSiteID = @ObjectFromSiteID)
--   -- Doku SUBSTRING(dbo.Objects_tbl.ObjectName, 1, CHARINDEX('/', dbo.Objects_tbl.ObjectName) mach aus 4711/A --> 4711
-- end
-- go

--------------------------------------------------------------------------------



-- Print ('Execute Report_905_Analysis_AllSites_IR_inconsistent')
-- GO
-- Execute Report_905_Analysis_AllSites_IR_inconsistent
-- GO
-- Execute Report_203_SingleSite_RefileStatus_by_DataSets
-- Go
--  Execute Report_204_SingleSite_RefileErrorList
--  Go
-- Execute Rrt_200_ProcStatus_by_DataSets_MultiSiteYes 'tceng' , 'ProcStateCol07'
-- go
--   execute Report_203_ProcStatus_by_DataSets_Count 'tceng' , 'ProcStateCol07'
--   go

-- Execute Report_301_List_of_all_Datasets_With_Errors 'tceng' , 'ProcStateCol07'
-- GO
--   declare @DateTimeStart datetime
--   set @DateTimeStart = GetDate()
--   -- DBCC DROPCLEANBUFFERS
--
--   Print ('Report_101_Objects_Datasets_Sum')
--   -- Execute  Rrt_200_ProcStatus_by_DataSets_MultiSiteYes 'plm2' , 'ProcStateColRf'
--   Execute  Report_101_Objects_Datasets_Sum '%tc%' , ''
--
--   Execute JF_ShowTimeDiffToNow 'Rrt_200_ProcStatus_by_DataSets_MultiSiteYes Delta:', @DateTimeStart
--   go
--
-- Declare @ExecuteSQLstr nvarchar(max)
-- select @ExecuteSQLstr=Value from zzzzzDebug_tbl  where Name = '@ExecuteSQLstr'
-- Print ''
-- Print ''
-- Print '@ExecuteSQLstr:'
-- Print '---------------'
-- Print @ExecuteSQLstr

Print ''
Print '----------------------------------------------------'
Print ' R E P O R T S imported to #DB_N#'
Print '----------------------------------------------------'
GO
