Print ''
Print '-------------------------------------------------------------------------'
Print ' using Database: #DB_N#'
Print ' Procedures    : JobControl'
Print ' Creation Date : 12.02.2010'
Print ' Autor         : J.Feuerstein'
Print ' '
Print '-------------------------------------------------------------------------'
GO

use [#DB_N#]
GO

Print '-'
Print '-- [JobControl_ObjectsProcess_tbl_JobPlaner_ObjectsProcessData] ---------'
If Exists (select Name
           from sysobjects
           where Name = "JobControl_ObjectsProcess_tbl_JobPlaner_ObjectsProcessData" and type = "P")
Drop Procedure JobControl_ObjectsProcess_tbl_JobPlaner_ObjectsProcessData
GO

CREATE PROCEDURE JobControl_ObjectsProcess_tbl_JobPlaner_ObjectsProcessData
          @Object_tbl_ID  nvarchar(64)   -- ID des Datensatzes in dbo.JobControl_ObjectsProcessData_tbl.Objects_tbl_ID

/* Neu: 12.02.2010 15:33 / J.Fes
   Description: Sucht in JobControl_ObjectsProcessData_tbl nach unbearbeiteten JobPlaner eintrag zur bergebenen @Object_tbl_ID
                 siehe hierzu .Net V.02-VB.NET\JobServer.DataSource\JobServer_DataSource.vb:JobControl_ObjectsProcess_tbl_JobPlaner_ObjectsProcessData
   Letze Anpassung: 04.04.2012 20:27  WHERE
    dbo.JobControl_ObjectsProcessData_tbl.Row_isLastRes = 1 -- AND
   order by dbo.JobControl_ObjectsProcessData_tbl.ProcessTimeStart DESC
*/
AS
BEGIN

SELECT TOP 1
  dbo.JobControl_ObjectsProcessData_tbl.ID,
  dbo.JobControl_ObjectsProcessData_tbl.Objects_tbl_ID,
  dbo.JobControl_ObjectsProcessData_tbl.ProcessState,
  dbo.JobControl_ObjectsProcessData_tbl.JobControlRuleName,
  dbo.JobControl_ObjectsProcessData_tbl.ProcessPacketName,
  dbo.JobControl_ObjectsProcessData_tbl.ProcessOnSiteID,
  dbo.JobControl_ObjectsProcessData_tbl.ProcessTimeStart,
  dbo.JobControl_ObjectsProcessData_tbl.ProcessTimeEnd,
  dbo.JobControl_ObjectsProcessData_tbl.ProcessCMDLine,
  dbo.JobControl_ObjectsProcessData_tbl.ProcessResultCode,
  dbo.JobControl_ObjectsProcessData_tbl.ProcessResultMsg,
  dbo.JobControl_ObjectsProcessData_tbl.ProcessOnComputer,
  dbo.JobControl_ObjectsProcessData_tbl.TaskScheduler_tbl_ID,
  dbo.JobControl_ObjectsProcessData_tbl.ProcessProcStateCol,
  dbo.JobControl_ObjectsProcessData_tbl.Row_isLastRes,
  dbo.JobControl_ObjectsProcessData_tbl.ProcessResultLink,
  dbo.JobControl_ObjectsProcessData_tbl.ProcessResultHasWarning,
  dbo.Objects_tbl.ObjectName,
  dbo.Objects_tbl.ObjectFromSiteID,
  dbo.Objects_tbl.ObjectClass,
  dbo.Objects_tbl.ObjectType,
  dbo.Objects_tbl.ObjectCliName,
  dbo.Objects_tbl.ObjectOwningSiteID,
  dbo.Objects_tbl.ObjectOwner,
  dbo.Objects_tbl.ObjectGroup,
  dbo.Objects_tbl.ObjectCreateDate,
  dbo.Objects_tbl.ObjectLastModUser,
  dbo.Objects_tbl.ObjectLastModDate,
  dbo.Objects_tbl.ObjectSelectByMarker,
  dbo.Objects_tbl.ObjectUgMaster_Type,
  dbo.Objects_tbl.ObjectUgMaster_CompCount,
  dbo.Objects_tbl.ObjectUgMaster_FsHitCount,
  dbo.Objects_tbl.ObjectFs_DPNE,
  dbo.Objects_tbl.ObjectFs_Vol,
  dbo.Objects_tbl.ObjectFs_NE,
  dbo.Objects_tbl.ObjectUgMaster_PartFamMemName,
  dbo.Objects_tbl.ObjectNote,
  dbo.Objects_tbl.ProcStateCol01,
  dbo.Objects_tbl.ProcStateCol02,
  dbo.Objects_tbl.ProcStateCol03,
  dbo.Objects_tbl.ProcStateCol04,
  dbo.Objects_tbl.ProcStateCol05,
  dbo.Objects_tbl.ProcStateCol06,
  dbo.Objects_tbl.ProcStateCol07,
  dbo.Objects_tbl.ProcStateCol08,
  dbo.Objects_tbl.ProcStateCol09,
  dbo.Objects_tbl.ProcStateCol10,
  dbo.Objects_tbl.ObjectUgMaster_APLevels,
  dbo.Objects_tbl.ProcStateColRf,
  dbo.Objects_tbl.ObjectReleaseState,
  dbo.Objects_tbl.ObjectReleaseDate,
  dbo.Objects_tbl.ObjectName2,
  dbo.Objects_tbl.ObjectDescription,
  dbo.Objects_tbl.ObjectPuid,
  dbo.Objects_tbl.ImportObjectErr
FROM
  dbo.JobControl_ObjectsProcessData_tbl
  INNER JOIN dbo.Objects_tbl ON (dbo.JobControl_ObjectsProcessData_tbl.Objects_tbl_ID = dbo.Objects_tbl.Id)
WHERE
  dbo.JobControl_ObjectsProcessData_tbl.Objects_tbl_ID = @Object_tbl_ID AND
  dbo.JobControl_ObjectsProcessData_tbl.Row_isLastRes = 1 -- AND
  -- dbo.JobControl_ObjectsProcessData_tbl.ProcessPacketName = ''
ORDER BY
  dbo.JobControl_ObjectsProcessData_tbl.ProcessTimeStart DESC
END
GO
--------------------------------------------------------------------------------
--------------------------------------------------------------------------------
--------------------------------------------------------------------------------


-- Print ''
-- Print ''
-- Print ''
-- Print '----------------------------------------------------'
-- Print ' Test Procedures ObjectsUpdate_ProcessStatus_Mark_LastRes'
-- Print '----------------------------------------------------'
-- GO
-- im9t
-- Execute JobControl_ObjectsProcess_tbl_JobPlaner_ObjectsProcessData '5d7c3cc4-227d-4333-8615-dd40f70b909e'
-- go
-- goto ende
ende:

Print ''
Print '----------------------------------------------------'
Print ' Procedures imported to #DB_N#'
Print '----------------------------------------------------'
GO
